/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.bill.web;

import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.models.fee.entity.FeeSettlement;
import com.bcxin.models.fee.service.FeeSettlementService;
import com.bcxin.models.order.dao.OrderFormDao;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${apiPath}/bill/sub"})
public class BillSubController
extends BaseController {
    private static final String SUBDISTRIBUTOR_LIST = BillSubController.getViewPath((String)"admin/fee/company/api/subdistributor_list");
    private static final String DISTRIBUTOR_DETATIL = BillSubController.getViewPath((String)"admin/fee/company/api/next/distributor_detatil");
    @Autowired
    private OrderFormDao orderFormDao;
    @Autowired
    private SysCompanyService companyService;
    @Autowired
    private FeeSettlementService feeSettlementService;

    @RequestMapping(value={"/initDistributorListByID"})
    public String InitDistributorList(HttpServletRequest request, Model model) {
        String uid = request.getParameter("uid");
        if (StringUtils.isEmpty((CharSequence)uid)) {
            this.logger.info("uid \u4e3a\u7a7a");
            return "redirect:/api/bill/noFind";
        }
        String distributorId = this.orderFormDao.findCompanyIDByID(uid);
        if (distributorId == null || "null".equals(distributorId) || "".equals(distributorId)) {
            this.logger.info("\u8ba2\u5355\u672a\u627e\u5230\u5f52\u5c5e\u7684\u5206\u9500\u5546");
            return "redirect:/api/bill/noFind";
        }
        SysCompany company = this.companyService.get(Long.valueOf(Long.parseLong(distributorId)));
        if (company == null) {
            return "redirect:/api/bill/noFind";
        }
        SysUser user = new SysUser();
        user.setLoginName("\u57f9\u8bad\u8d26\u53f7");
        request.getSession().setAttribute("company", (Object)company);
        Map map = this.feeSettlementService.getTotalFee(SysCompany.COMPANY_TYPE_DISTRIBUTOR.toString());
        model.addAttribute("map", (Object)map);
        List companyList = this.companyService.getSysCompanyLowLeverList(company.getId());
        model.addAttribute("companyList", (Object)companyList);
        return SUBDISTRIBUTOR_LIST;
    }

    @RequestMapping(value={"/getDetatilList/{id}"})
    public String getDetatilList(Model model, @PathVariable Long id, FeeSettlement feeSettlement, HttpServletRequest request) {
        SysCompany sysCompany = (SysCompany)this.companyService.selectById((Serializable)id);
        model.addAttribute("company", (Object)sysCompany);
        feeSettlement.setSysCompany(sysCompany);
        if (sysCompany != null && 2 == sysCompany.getCompanyType()) {
            request.getSession().setAttribute("feeSettlement", (Object)feeSettlement);
            return DISTRIBUTOR_DETATIL;
        }
        return null;
    }

    @RequestMapping(value={"/getDistributorListDataByID"})
    @ResponseBody
    public String getDistributorListDataByID(HttpServletRequest request, Model model, FeeSettlement feeSettlement) {
        SysCompany company = (SysCompany)request.getSession().getAttribute("company");
        if (company == null) {
            return "";
        }
        Page page = this.getPage();
        feeSettlement.setParentID(company.getId());
        feeSettlement.setSysType(SysCompany.COMPANY_TYPE_DISTRIBUTOR.toString());
        feeSettlement.setSysCompany(company);
        this.feeSettlementService.findPage(page, feeSettlement, feeSettlement.getSysType());
        return this.jsonPage(page);
    }

    @RequestMapping(value={"/getDetatilListData"})
    @ResponseBody
    public String getDetatilListData(FeeSettlement feeSettlement, HttpServletRequest request) {
        FeeSettlement fee = (FeeSettlement)request.getSession().getAttribute("feeSettlement");
        if (fee != null) {
            feeSettlement.setsDate(fee.getsDate());
            feeSettlement.seteDate(fee.geteDate());
        }
        Page page = this.getPage();
        this.feeSettlementService.findPage(page, feeSettlement, null);
        return this.jsonPage(page);
    }

    @RequestMapping(value={"/getOrderNum"})
    @ResponseBody
    public Map<String, Object> getOrderNum(HttpServletRequest request, Model model, String companyId, FeeSettlement feeSettlement) {
        SysCompany company = (SysCompany)request.getSession().getAttribute("company");
        Map map = null;
        if (company == null) {
            map.put("totalNum", "0");
            map.put("totalMoney", "0");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sDate", feeSettlement.getsDate());
        param.put("eDate", feeSettlement.geteDate());
        param.put("sysCompanyId", feeSettlement.getSysCompanyId());
        param.put("likeValue", feeSettlement.getLikeValue());
        param.put("parentID", company.getId());
        map = this.feeSettlementService.findFeeSettlementSubTongJi(param);
        return map;
    }
}

