/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.bill.web;

import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.models.fee.entity.FeeSettlement;
import com.bcxin.models.fee.service.FeeSettlementService;
import com.bcxin.models.order.dao.OrderFormDao;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${apiPath}/bill/"})
public class BillController
extends BaseController {
    private static final String DISTRIBUTOR_LIST = BillController.getViewPath((String)"admin/fee/company/api/distributor_list");
    private static final String DISTRIBUTOR_DETAIL = BillController.getViewPath((String)"admin/fee/company/api/distributor_detatil");
    private static final String DISTRIBUTOR_NOT_FIND = BillController.getViewPath((String)"admin/fee/company/api/404");
    @Autowired
    private OrderFormDao orderFormDao;
    @Autowired
    private SysCompanyService companyService;
    @Autowired
    private FeeSettlementService feeSettlementService;

    @RequestMapping(value={"/receiveFeeSettlementData"})
    public String receiveFeeSettlementData(HttpServletRequest request, Model model) {
        String uid = request.getParameter("uid");
        if (StringUtils.isEmpty((CharSequence)uid)) {
            this.logger.info("uid \u4e3a\u7a7a");
            return "redirect:/api/bill/noFind";
        }
        String distributorId = this.orderFormDao.findCompanyIDByID(uid);
        if (distributorId == null || "null".equals(distributorId) || "".equals(distributorId)) {
            this.logger.info("\u8ba2\u5355\u672a\u627e\u5230\u5f52\u5c5e\u7684\u5206\u9500\u5546");
            return "redirect:/api/bill/noFind";
        }
        SysCompany company = this.companyService.get(Long.valueOf(Long.parseLong(distributorId)));
        if (company == null) {
            this.logger.info("\u8ba2\u5355\u672a\u67e5\u627e\u8be5\u5206\u9500\u5546\u8d26\u53f7");
            return "redirect:/api/bill/noFind";
        }
        SysUser user = new SysUser();
        user.setLoginName("\u57f9\u8bad\u8d26\u53f7");
        request.getSession().setAttribute("company", (Object)company);
        if (2 == company.getCompanyType()) {
            return DISTRIBUTOR_LIST;
        }
        if (4 == company.getCompanyType()) {
            // empty if block
        }
        if (1 == company.getCompanyType()) {
            // empty if block
        }
        return "redirect:/api/bill/noFind";
    }

    @RequestMapping(value={"/getDistributorListData"})
    @ResponseBody
    public String getDistributorListData(HttpServletRequest request, Model model, FeeSettlement feeSettlement) {
        SysCompany company = (SysCompany)request.getSession().getAttribute("company");
        if (company == null) {
            return "redirect:/api/bill/noFind";
        }
        Page page = this.getPage();
        feeSettlement.setSysType(SysCompany.COMPANY_TYPE_DISTRIBUTOR.toString());
        feeSettlement.setSysCompany(company);
        this.feeSettlementService.findOnePage(page, feeSettlement, feeSettlement.getSysType());
        return this.jsonPage(page);
    }

    @RequestMapping(value={"/getDetatilList/{id}"})
    public String getDetatilList(Model model, @PathVariable Long id) {
        FeeSettlement fee = (FeeSettlement)this.feeSettlementService.selectById((Serializable)id);
        Map feeMap = this.feeSettlementService.getFeeDetaitil(id);
        if (fee == null) {
            return "redirect:/api/bill/noFind";
        }
        model.addAttribute("fee", (Object)fee);
        model.addAttribute("feeMap", (Object)feeMap);
        return DISTRIBUTOR_DETAIL;
    }

    @RequestMapping(value={"/noFind"})
    public String noFind(Model model) {
        return DISTRIBUTOR_NOT_FIND;
    }

    @RequestMapping(value={"/getOrderNum"})
    @ResponseBody
    public Map<String, Object> getOrderNum(HttpServletRequest request, Model model, String companyId, FeeSettlement feeSettlement) {
        SysCompany company = (SysCompany)request.getSession().getAttribute("company");
        Map map = null;
        if (company == null) {
            map.put("totalNum", "0");
            map.put("totalMoney", "0");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sDate", feeSettlement.getsDate());
        param.put("eDate", feeSettlement.geteDate());
        param.put("sysCompanyId", company.getId());
        param.put("likeValue", feeSettlement.getLikeValue());
        map = this.feeSettlementService.findFeeSettlementTongJi(param);
        return map;
    }
}

