/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.responses;

import java.util.Collection;
import java.util.Date;

public class DbDataImportResponse {
    private final Collection<DataSetResult> dataSetResults;
    private final Date time;

    public DbDataImportResponse(Collection<DataSetResult> dataSetResults) {
        this.dataSetResults = dataSetResults;
        this.time = new Date();
    }

    public boolean getIsSuccess() {
        return this.dataSetResults.stream().allMatch(ii -> ((DataSetResult)ii).isSuccess);
    }

    public static DbDataImportResponse create(Collection<DataSetResult> dataSetResults) {
        return new DbDataImportResponse(dataSetResults);
    }

    public Collection<DataSetResult> getDataSetResults() {
        return this.dataSetResults;
    }

    public Date getTime() {
        return this.time;
    }

    public static class DataSetResult {
        private final String id;
        private final boolean isSuccess;
        private final String result;

        public DataSetResult(String id, boolean isSuccess, String result) {
            this.id = id;
            this.isSuccess = isSuccess;
            this.result = result;
        }

        public static DataSetResult create(String id, boolean isSuccess, String result) {
            return new DataSetResult(id, isSuccess, result);
        }

        public String getId() {
            return this.id;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getResult() {
            return this.result;
        }
    }
}

