/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.requests;

import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncCommand;
import com.bcxin.runtime.domain.syncs.commands.CreateFtpDataSyncCommand;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.sync.apis.requests.RequestAbstract;
import com.bcxin.sync.apis.requests.SyncViaDirectlyDbDataImportRequest;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SyncViaFtpDataImportRequest
extends RequestAbstract {
    private String data;
    private String businessType;
    private String filePaths;
    private Map urlFilePathMappings;

    public CreateFtpDataSyncCommand getCommand(JsonProvider jsonProvider) {
        SyncViaDirectlyDbDataImportRequest dataImportRequest = null;
        try {
            dataImportRequest = (SyncViaDirectlyDbDataImportRequest)jsonProvider.getData(this.getData(), SyncViaDirectlyDbDataImportRequest.class);
        }
        catch (Exception e) {
            String jsonData = StringEscapeUtils.unescapeJava((String)this.getData());
            dataImportRequest = (SyncViaDirectlyDbDataImportRequest)jsonProvider.getData(jsonData, SyncViaDirectlyDbDataImportRequest.class);
        }
        Collection ds = dataImportRequest.getDataSets().stream().map(ii -> CreateDataSyncCommand.DataSet.create((String)ii.getId(), (String)ii.getMapKey(), ii.getDataRecords(), ii.getDeletedIds())).collect(Collectors.toList());
        String filePaths = this.getFilePaths();
        Map urlFilePathMappings = this.urlFilePathMappings;
        if (!StringUtils.hasLength((String)filePaths)) {
            filePaths = dataImportRequest.getFilePaths();
            urlFilePathMappings = dataImportRequest.getUrlFilePathMappings();
        }
        return CreateFtpDataSyncCommand.create((Collection)ds, (String)this.getBusinessType(), (String)filePaths, (Map)urlFilePathMappings);
    }

    @Override
    public void validate() {
        Assert.hasLength((String)this.data, (String)"data\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)this.businessType, (String)"businessType\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    public String getData() {
        return this.data;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getFilePaths() {
        return this.filePaths;
    }

    public Map getUrlFilePathMappings() {
        return this.urlFilePathMappings;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setFilePaths(String filePaths) {
        this.filePaths = filePaths;
    }

    public void setUrlFilePathMappings(Map urlFilePathMappings) {
        this.urlFilePathMappings = urlFilePathMappings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncViaFtpDataImportRequest)) {
            return false;
        }
        SyncViaFtpDataImportRequest other = (SyncViaFtpDataImportRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$filePaths = this.getFilePaths();
        String other$filePaths = other.getFilePaths();
        if (this$filePaths == null ? other$filePaths != null : !this$filePaths.equals(other$filePaths)) {
            return false;
        }
        Map this$urlFilePathMappings = this.getUrlFilePathMappings();
        Map other$urlFilePathMappings = other.getUrlFilePathMappings();
        return !(this$urlFilePathMappings == null ? other$urlFilePathMappings != null : !((Object)this$urlFilePathMappings).equals(other$urlFilePathMappings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SyncViaFtpDataImportRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $filePaths = this.getFilePaths();
        result = result * 59 + ($filePaths == null ? 43 : $filePaths.hashCode());
        Map $urlFilePathMappings = this.getUrlFilePathMappings();
        result = result * 59 + ($urlFilePathMappings == null ? 43 : ((Object)$urlFilePathMappings).hashCode());
        return result;
    }

    public String toString() {
        return "SyncViaFtpDataImportRequest(data=" + this.getData() + ", businessType=" + this.getBusinessType() + ", filePaths=" + this.getFilePaths() + ", urlFilePathMappings=" + this.getUrlFilePathMappings() + ")";
    }
}

