/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.interceptor;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import cn.myapps.base.web.interceptor.FileDownloadInterceptor;
import com.bcxin.sync.apis.configs.FileModeConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class FileModeDownloadInterceptor
extends FileDownloadInterceptor {
    private static Logger logger = LoggerFactory.getLogger(FileModeDownloadInterceptor.class);

    public boolean preHandle(HttpServletRequest req, HttpServletResponse resp, Object handler) throws ServletException, IOException {
        String url = req.getRequestURI();
        if (FileModeConfig.getUseFtp().booleanValue() && StringUtils.hasLength((String)url) && url.indexOf("/uploads/lib/icon/") < 0) {
            int pos = url.indexOf("/uploads/");
            if (pos >= 0) {
                url = url.substring(pos);
            } else {
                pos = url.indexOf("/upload/");
                if (pos >= 0) {
                    url = url.substring(pos);
                }
            }
            try {
                String filePath = url.substring(0, url.lastIndexOf("/") + 1);
                String fileName = url.substring(url.lastIndexOf("/") + 1);
                fileName = URLDecoder.decode(fileName, "utf-8");
                String path = (StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + filePath;
                Ftp ftp = new Ftp(FileModeConfig.getHost(), FileModeConfig.getPort(), FileModeConfig.getUserName(), FileModeConfig.getPassword());
                ftp.setMode(FtpMode.Passive);
                String pathFileName = String.format("%s%s", path, fileName);
                System.setProperty("org.apache.commons.net.ftp.systemType.default", "UNIX");
                if (!ftp.existFile(pathFileName)) {
                    ftp.close();
                    throw new FileNotFoundException(String.format("FTP\u4e0a\u627e\u4e0d\u5230\u6587\u4ef6:%s", pathFileName));
                }
                resp.reset();
                ServletOutputStream out = resp.getOutputStream();
                resp.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
                ftp.download(path, fileName, (OutputStream)out);
                if (out != null) {
                    out.close();
                    out.flush();
                }
                ftp.close();
                return false;
            }
            catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) {
                    try (ServletOutputStream out = resp.getOutputStream();){
                        resp.setStatus(HttpStatus.NOT_FOUND.value());
                        out.write(String.format("\u6587\u4ef6(%s)\u4e0b\u8f7d\u5931\u8d25, \u8bf7\u7a0d\u540e\u91cd\u8bd5(%s)", url, e.getMessage()).getBytes());
                        out.close();
                        out.flush();
                    }
                    return false;
                }
                logger.error("\u6587\u4ef6({})\u4e0b\u8f7d\u5931\u8d25:{}", (Object)url, (Object)e);
            }
        }
        return super.preHandle(req, resp, handler);
    }
}

