/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.syncs.commands.CreateSyncFileCommand;
import com.bcxin.runtime.domain.syncs.commands.results.CreateDataSyncCommandResult;
import com.bcxin.runtime.domain.syncs.services.DataSyncService;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.requests.SyncViaDirectlyDbDataImportRequest;
import com.bcxin.sync.apis.requests.SyncViaDirectlyFileDataImportRequest;
import com.bcxin.sync.apis.responses.DbDataImportResponse;
import com.bcxin.web.commons.responses.ErrorResponse;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/sync/db"})
public class SyncViaDirectlyController {
    private final DataSyncService dataSyncService;

    public SyncViaDirectlyController(DataSyncService dataSyncService) {
        this.dataSyncService = dataSyncService;
    }

    @PostMapping(value={"/data-import"})
    public ResponseEntity post(@RequestBody SyncViaDirectlyDbDataImportRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            request.validate();
            CreateDataSyncCommandResult result = this.dataSyncService.create(request.getCommand(), null);
            Collection dataSetResults = result.getDataSetResults().stream().map(ii -> DbDataImportResponse.DataSetResult.create(ii.getDataSetId(), ii.isSuccess(), ii.getResult())).collect(Collectors.toList());
            sb.append("\u6267\u884c\u6210\u529f;");
            return ResponseEntity.ok((Object)DbDataImportResponse.create(dataSetResults));
        }
        catch (Exception ex) {
            String error = String.format("Exception-\u660e\u7ec6: %s", ExceptionUtils.getStackMessage((Throwable)ex));
            sb.append(error);
            return ResponseEntity.badRequest().body((Object)ErrorResponse.create((String)sb.toString(), (Exception)ex));
        }
    }

    @PostMapping(value={"/file-import"})
    public ResponseEntity post(@RequestBody SyncViaDirectlyFileDataImportRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            request.validate();
            CreateSyncFileCommand command = request.getCommand();
            CreateSyncFileCommand.CreateSyncFileCommandResult result = this.dataSyncService.create(command);
            sb.append("\u6267\u884c\u6210\u529f;");
            return ResponseEntity.ok((Object)result);
        }
        catch (Exception ex) {
            String error = String.format("Exception-\u660e\u7ec6: %s", ExceptionUtils.getStackMessage((Throwable)ex));
            sb.append(error);
            return ResponseEntity.badRequest().body((Object)ErrorResponse.create((String)sb.toString(), (Exception)ex));
        }
    }
}

