package com.bcxin.sync.apis.requests;

import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncCommand;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.saas.core.exceptions.SaasBadException;
import lombok.Data;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class SyncViaDirectlyDbDataImportRequest extends RequestAbstract {
    private Collection<DataSet> dataSets;
    private String filePaths;
    private Map urlFilePathMappings;


    @Override
    public void validate() {
        Assert.notEmpty(this.dataSets, "数据源不能为空");
    }

    @Data
    public static class DataSet {
        private String id;
        private String mapKey;
        private Collection<DataSetDto.Row> dataRecords;
        private Collection<String> deletedIds;

        public DataSet() {

        }
    }

    public CreateDataSyncCommand getCommand() {
        Collection<CreateDataSyncCommand.DataSet> ds =
                this.getDataSets().stream().map(ii -> {
                    return CreateDataSyncCommand.DataSet
                            .create(ii.getId(), ii.getMapKey(),
                                    ii.getDataRecords(), ii.getDeletedIds());
                }).collect(Collectors.toList());

        return CreateDataSyncCommand.create(ds, this.getFilePaths(), this.getUrlFilePathMappings());
    }
}
