package com.bcxin.sync.apis.interceptor;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import cn.myapps.base.web.interceptor.FileDownloadInterceptor;
import com.bcxin.sync.apis.configs.FileModeConfig;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

/**
 * @Auther linqinglin
 * @date 2022/4/3 10:11
 */
public class FileModeDownloadInterceptor extends FileDownloadInterceptor {

    private static org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(FileModeDownloadInterceptor.class);

    @Override
    public boolean preHandle(HttpServletRequest req, HttpServletResponse resp, Object handler) throws ServletException, IOException {
        String url = req.getRequestURI();
        if (FileModeConfig.getUseFtp() && StringUtils.hasLength(url)
                && url.indexOf("/uploads/lib/icon/") < 0) {
            int pos = url.indexOf("/uploads/");
            if (pos >= 0) {
                url = url.substring(pos);
            } else {
                pos = url.indexOf("/upload/");
                if (pos >= 0) {
                    url = url.substring(pos);
                }
            }

            //ftp只能取图片，zip或rar从硬盘取
            try {
                //文件路径
                String filePath = url.substring(0, url.lastIndexOf("/") + 1);
                //文件名称
                String fileName = url.substring(url.lastIndexOf("/") + 1);
                fileName = java.net.URLDecoder.decode(fileName, "utf-8");

                String path = (StrUtil.isEmpty(FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + filePath;
                Ftp ftp = new Ftp(FileModeConfig.getHost(), FileModeConfig.getPort(), FileModeConfig.getUserName(), FileModeConfig.getPassword());
                ftp.setMode(FtpMode.Passive);
                String pathFileName = String.format("%s%s", path, fileName);
                ServletOutputStream out;
                System.setProperty(FTPClient.FTP_SYSTEM_TYPE_DEFAULT, FTPClientConfig.SYST_UNIX);
                if (!ftp.existFile(pathFileName)) {
                    ftp.close();
                    throw new FileNotFoundException(String.format("FTP上找不到文件:%s", pathFileName));
                } else {
                    resp.reset();
                    out = resp.getOutputStream();
                    resp.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
                    ftp.download(path, fileName, out);
                }
                if (out != null) {
                    out.close();
                    out.flush();
                }
                ftp.close();
                return false;
            } catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) {
                    try (ServletOutputStream out = resp.getOutputStream()) {
                        resp.setStatus(HttpStatus.NOT_FOUND.value());
                        out.write(String.format("文件(%s)下载失败, 请稍后重试(%s)", url, e.getMessage()).getBytes());
                        out.close();
                        out.flush();
                    }
                    return false;
                }
                logger.error("文件({})下载失败:{}", url, e);
            }
        }

        return super.preHandle(req, resp, handler);
    }
}
