package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.syncs.commands.CreateSyncFileCommand;
import com.bcxin.runtime.domain.syncs.commands.results.CreateDataSyncCommandResult;
import com.bcxin.runtime.domain.syncs.services.DataSyncService;
import com.bcxin.saas.core.logs.SysLogProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.requests.SyncViaDirectlyDbDataImportRequest;
import com.bcxin.sync.apis.requests.SyncViaDirectlyFileDataImportRequest;
import com.bcxin.sync.apis.responses.DbDataImportResponse;
import com.bcxin.web.commons.responses.ErrorResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/v2/sync/db")
public class SyncViaDirectlyController {
    private final DataSyncService dataSyncService;

    public SyncViaDirectlyController(DataSyncService dataSyncService) {
        this.dataSyncService = dataSyncService;
    }

    @PostMapping("/data-import")
    public ResponseEntity post(
            @RequestBody SyncViaDirectlyDbDataImportRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            request.validate();
            CreateDataSyncCommandResult result =
                    this.dataSyncService.create(request.getCommand(),null);

            Collection<DbDataImportResponse.DataSetResult> dataSetResults
                    = result.getDataSetResults().stream().map(ii -> {
                return DbDataImportResponse.DataSetResult.create(ii.getDataSetId(), ii.isSuccess(), ii.getResult());
            }).collect(Collectors.toList());

            sb.append("执行成功;");
            return ResponseEntity.ok(DbDataImportResponse.create(dataSetResults));
        } catch (Exception ex) {
            String error = String.format("Exception-明细: %s", ExceptionUtils.getStackMessage(ex));
            sb.append(error);
            return ResponseEntity.badRequest().body(ErrorResponse.create(sb.toString(), ex));
        }
    }

    @PostMapping("/file-import")
    public ResponseEntity post(@RequestBody SyncViaDirectlyFileDataImportRequest request) {
        StringBuilder sb = new StringBuilder();
        try {
            request.validate();
            CreateSyncFileCommand command = request.getCommand();
            CreateSyncFileCommand.CreateSyncFileCommandResult result =
                    this.dataSyncService.create(command);

            sb.append("执行成功;");
            return ResponseEntity.ok(result);
        } catch (Exception ex) {
            String error = String.format("Exception-明细: %s", ExceptionUtils.getStackMessage(ex));
            sb.append(error);

            return ResponseEntity.badRequest().body(ErrorResponse.create(sb.toString(), ex));
        }
    }
}
