package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.metas.commands.RefreshFormSyncTargetMetaCommand;
import com.bcxin.runtime.domain.metas.entities.FormSyncTargetMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.FormSyncTargetMetaRepository;
import com.bcxin.runtime.domain.metas.services.FormSyncTargetMetaService;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.requests.FormSyncTargetRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;

import java.util.Collection;
import java.util.stream.Collectors;

@RestController("com.bcxin.sync.apis.controllers.FormSyncTargetMetaController")
@RequestMapping(value = "/v2/sync/form-sync-targets")
public class FormSyncTargetMetaController {
    private final FormSyncTargetMetaService formSyncTargetMetaService;
    private final FormSyncTargetMetaRepository formSyncTargetMetaRepository;
    private final JsonProvider jsonProvider;
    public FormSyncTargetMetaController(FormSyncTargetMetaService formSyncTargetMetaService,
                                        FormSyncTargetMetaRepository formSyncTargetMetaRepository,
                                        JsonProvider jsonProvider) {
        this.formSyncTargetMetaService = formSyncTargetMetaService;
        this.formSyncTargetMetaRepository = formSyncTargetMetaRepository;
        this.jsonProvider = jsonProvider;
    }


    @PostMapping
    public ResponseEntity post(@RequestBody FormSyncTargetRequest request) {
        try {
            RefreshFormSyncTargetMetaCommand command = request.getCommand();
            this.formSyncTargetMetaService.saveAll(command);

            return get();
        } catch (Exception ex) {
            return ResponseEntity.badRequest().body(ex.toString());
        }
    }

    @PutMapping
    public ResponseEntity put(@RequestBody FormSyncTargetRequest request)
    {
        try {
            RefreshFormSyncTargetMetaCommand command = request.getCommand();
            this.formSyncTargetMetaService.update(command);

            return get();
        } catch (Exception ex) {
            return ResponseEntity.badRequest().body(ex.toString());
        }
    }

    @GetMapping
    public ResponseEntity get()
    {
        try {
            Collection<FormSyncTargetMetaEntity> formSyncTargetMetaEntities =
                    this.formSyncTargetMetaRepository.findAll();

            return ResponseEntity.ok(formSyncTargetMetaEntities.stream().map(ii -> {
                FormSyncTargetRequest.TargetItem item = new FormSyncTargetRequest.TargetItem();
                item.setCode(ii.getId());
                item.setMethod(ii.getMethod());
                FormSyncTargetConfigSnapshot targetConfigSnapshot =
                        this.jsonProvider.getData(ii.getConfig(), FormSyncTargetConfigSnapshot.class);
                item.setTargetType(targetConfigSnapshot.getTargetType());
                item.setBodyAdditionalData(targetConfigSnapshot.getAdditionalData());
                item.setHeaders(targetConfigSnapshot.getHeaders());
                item.setFileUploadUrl(targetConfigSnapshot.getFileUploadUrl());
                item.setUrl(targetConfigSnapshot.getUrl());

                return item;
            }).collect(Collectors.toList()));
        }
        catch (Exception ex)
        {
            return ResponseEntity.badRequest().body(ExceptionUtils.getStackMessage(ex));
        }
    }

    @DeleteMapping("/{code}")
    public ResponseEntity delete(@PathVariable String code) {
        this.formSyncTargetMetaService.delete(code);

        return ResponseEntity.ok("成功!");
    }
}
