package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.syncs.commands.CreateSyncFileCommand;
import com.bcxin.runtime.domain.syncs.services.DataSyncService;
import com.bcxin.sync.apis.requests.SyncViaDirectlyFileDataImportRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class FileSyncController {
    private final DataSyncService dataSyncService;

    public FileSyncController(DataSyncService dataSyncService) {
        this.dataSyncService = dataSyncService;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody SyncViaDirectlyFileDataImportRequest request) {
        CreateSyncFileCommand command = request.getCommand();
        CreateSyncFileCommand.CreateSyncFileCommandResult result =
                this.dataSyncService.create(command);

        return ResponseEntity.ok(result);
    }
}
