package com.bcxin.runtime.apis.responses;

import lombok.Getter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Getter
public class AppRoleResponse implements Serializable {
    private final String id;
    private final String name;
    private final Collection<RoleItem> roles = new ArrayList<>();

    public AppRoleResponse(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static AppRoleResponse create(String id, String name)
    {
        return new AppRoleResponse(id,name);
    }

    public void assignRole(Collection<RoleItem> roles) {
        this.getRoles().addAll(roles);
    }


    @Getter
    public static class RoleItem {
        private final String id;
        private final String name;

        public RoleItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static RoleItem create(String id, String name) {
            return new RoleItem(id, name);
        }
    }
}
