package com.bcxin.runtime.apis.requests;

import cn.hutool.core.date.DateTime;
import com.bcxin.runtime.apis.dtos.SyncChangeLogTableDto;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;

@Data
public class DownChangelogRequest {
    private DateTime fromTime;
    private DateTime endTime;
    private String regionCode;
    private String regionName;
    private Collection<String> tables;
    private Map<String,String> dynamicParameterMaps;
    private Boolean needServerTimeCheck = false; // 是否需要进行服务器时间校对

    public void validate(HttpServletRequest servletRequest) {
        int amount = 600;
        String headValue = servletRequest.getHeader("skip_validation");
        if (StringUtils.hasLength(headValue)) {
            //特权, 跳过, 限制30个月
            if (new StringBuffer("skip_validation").reverse().toString().equals(headValue)) {
                amount = 100 * 30;
            }
        }

        Calendar supportedDate =
                Calendar.getInstance();
        supportedDate.add(Calendar.DAY_OF_MONTH, 0 - amount);
        if (fromTime.before(supportedDate.getTime())) {
            throw new SaasNoSupportException(String.format("系统只支持获取%s后变更的数据", new SimpleDateFormat("yyyy-MM-dd").format(supportedDate.getTime())));
        }
    }

    public boolean matched(SyncChangeLogTableDto changeLogTable) {
        if(StringUtils.hasLength(this.getRegionCode()) &&
                "govin-to-govout".equalsIgnoreCase(this.getRegionCode())) {
            /*
            if (!changeLogTable.isForGovOut()) {
                return false;
            }

             */
        }

        if (CollectionUtils.isEmpty(this.getTables())) {
            return true;
        }

        if (!StringUtils.hasLength(changeLogTable.getTableName())|| changeLogTable==null) {
            return false;
        }

        return this.getTables().stream().anyMatch(ii -> ii.equalsIgnoreCase(changeLogTable.getTableName())) ||
                this.getTables().stream().anyMatch(ix -> ix.equalsIgnoreCase(getAppTableName(changeLogTable.getAppId(), changeLogTable.getTableName())));
    }

    public static String getAppTableName(String appId, String tbName) {
        return String.format("%s|%s", appId, tbName);
    }
}
