package com.bcxin.runtime.apis.dtos;

import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Getter
public class ChangeLogDataResult {
    private final int countOfData;
    private final Collection<Map<String, Object>> data;
    private StringBuilder trackingBuilder = new StringBuilder();

    public ChangeLogDataResult( Collection<Map<String, Object>> data) {
        this.data = data;
        this.countOfData = data.size();
    }

    public static ChangeLogDataResult create(Collection<Map<String, Object>> data) {
        return new ChangeLogDataResult(data);
    }

    public void appendTracking(String msg) {
        trackingBuilder.append(msg);
    }
}
