package com.bcxin.runtime.apis.controllers;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import javax.servlet.http.HttpServletRequest;

public abstract class ControllerAbstract {

    @Autowired
    private HttpServletRequest servletRequest;

    protected String getCurrentUserId(HttpServletRequest servletRequest)
    {
        String userId = WebUser.getWebUserId(servletRequest);

        return userId;
    }

    protected String getCurrentDomainId(HttpServletRequest servletRequest) {
        String userId = getCurrentUserId(servletRequest);
        WebUser webUser = WebUser.getWebUserInstance(userId);
        if (webUser == null) {
            return null;
        }

        return webUser.getDomainid();
    }

    public void validateAllowed(HttpServletRequest servletRequest, String domainId) {
        String comparedDomainId = this.getCurrentDomainId(servletRequest);

        /*
        if (StringUtils.hasLength(domainId) && StringUtils.hasLength(comparedDomainId) && domainId.equalsIgnoreCase(comparedDomainId)) {
            return;
        }

        throw new SaasBadException("当前用户不允许修改其他组织的信息");
         */
    }

    protected IUser getWebUser() {
        WebUser webUser = WebUser.getWebUserInstance(getCurrentUserId(servletRequest));

        return webUser;
    }

    protected ResponseEntity notFound(Object body) {
        return ResponseEntity.status(HttpStatus.NOT_FOUND).body(body);
    }

    protected ResponseEntity ok(Object body) {
        return ResponseEntity.ok(body);
    }

    protected ResponseEntity badRequest(Object body) {
        return ResponseEntity.badRequest().body(body);
    }
}
