/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.configs;

import com.bcxin.runtime.domain.imports.repositories.DataQueueRepository;
import com.bcxin.runtime.domain.messages.repositories.MessageRepository;
import com.bcxin.runtime.domain.permissions.repositories.DataPermissionScopeRepository;
import com.bcxin.runtime.domain.repositories.components.DataPermissionScopeProviderImpl;
import com.bcxin.runtime.domain.repositories.imports.repositories.JpaDataQueueRepository;
import com.bcxin.runtime.domain.repositories.messages.repositories.JpaMessageRepository;
import com.bcxin.runtime.domain.repositories.permissions.repositories.JpaDataPermissionScopeRepository;
import com.bcxin.saas.core.components.CookieProvider;
import com.bcxin.saas.core.components.DataPermissionScopeConfig;
import com.bcxin.saas.core.components.DataPermissionScopeProvider;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.components.ThreadContextManager;
import com.bcxin.saas.core.enums.EnvironmentType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration(value="com.bcxin.runtime.apis.configs.RuntimeSetupConfig")
@EnableJpaRepositories(basePackages={"com.bcxin.runtime.domain.repositories.messages.repositories", "com.bcxin.runtime.domain.repositories.permissions.repositories", "com.bcxin.runtime.domain.repositories.imports.repositories", "com.bcxin.runtime.domain.repositories.metas.repositories", "com.bcxin.runtime.domain.repositories.syncs.repositories", "com.bcxin.event.repositories.repositories"})
@EntityScan(basePackages={"com.bcxin.runtime.domain.messages.entities", "com.bcxin.runtime.domain.permissions.entities", "com.bcxin.runtime.domain.imports.entities", "com.bcxin.runtime.domain.metas.entities", "com.bcxin.runtime.domain.syncs.entities", "com.bcxin.event.entities"})
public class RuntimeApiSetupConfig {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeApiSetupConfig.class);

    public RuntimeApiSetupConfig() {
        logger.error("RuntimeSetupConfig \u521d\u59cb\u5316\u64cd\u4f5c");
    }

    @Bean
    public MessageRepository messageRepository(JpaMessageRepository jpaMessageRepository) {
        return jpaMessageRepository;
    }

    @Bean
    public DataPermissionScopeRepository dataPermissionScopeRepository(JpaDataPermissionScopeRepository jpaDataPermissionScopeRepository) {
        return jpaDataPermissionScopeRepository;
    }

    @Bean
    public DataPermissionScopeProvider dataPermissionScopeProvider(JsonProvider jsonProvider, ThreadContextManager threadContextManager, DistributedCacheProvider distributedCacheProvider, JpaDataPermissionScopeRepository dataPermissionScopeRepository, CookieProvider cookieProvider, DataPermissionScopeConfig dataPermissionScopeConfig) {
        return new DataPermissionScopeProviderImpl(jsonProvider, threadContextManager, cookieProvider, distributedCacheProvider, dataPermissionScopeRepository, dataPermissionScopeConfig);
    }

    @Bean
    public DataPermissionScopeConfig dataPermissionScopeConfig(@Value(value="${myapps.environment:}") String env, @Value(value="${myapps.dataScope:}") String dataScope, @Value(value="${myapps.conditionAppIds:}") List<String> conditionAppIds) {
        EnvironmentType environmentType = EnvironmentType.Network;
        if ("security".equalsIgnoreCase(env)) {
            environmentType = EnvironmentType.Government_Inner;
        } else if ("security-network".equalsIgnoreCase(env)) {
            environmentType = EnvironmentType.Government_Network;
        }
        DataPermissionScopeConfig config = new DataPermissionScopeConfig(dataScope, conditionAppIds, environmentType);
        return config;
    }

    @Bean
    public DataQueueRepository dataQueueRepository(JpaDataQueueRepository jpaDataQueueRepository) {
        return jpaDataQueueRepository;
    }
}

