/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.ThreadContextManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ThreadContextManagerImpl
implements ThreadContextManager {
    @Resource
    private HttpServletRequest servletRequest;
    private static final Logger logger = LoggerFactory.getLogger(ThreadContextManagerImpl.class);
    private static final ThreadLocal<Map<String, Object>> threadManager = new InheritableThreadLocal<Map<String, Object>>();
    private static final String CURRENT_THREAD_KEY = "CURRENT_THREAD_KEY.RQ";

    public <T> void store(String key, T instance) {
        Map<String, Object> mp = this.getMap();
        if (instance == null) {
            if (mp.containsKey(key)) {
                mp.remove(key);
            }
        } else {
            mp.put(key, instance);
        }
        this.setMap(mp);
    }

    public <T> T get(String key) {
        Map<String, Object> mp = this.getMap();
        return (T)mp.get(key);
    }

    public <T> T get(String key, Supplier<T> supplier, Class<T> tClass) {
        T instance = this.get(key);
        try {
            Connection conn;
            boolean createNew = false;
            if (instance == null) {
                createNew = true;
            }
            if (!createNew && tClass.isAssignableFrom(Connection.class) && (conn = (Connection)instance) != null && conn.isClosed()) {
                createNew = true;
            }
            if (createNew) {
                instance = supplier.get();
                this.store(key, instance);
            }
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u5b9e\u4f8b\u4fe1\u606f\uff08{}\uff09\u53d1\u751f\u5f02\u5e38", (Object)key, (Object)ex);
        }
        return instance;
    }

    public void clear() throws SQLException {
        Map<String, Object> mp = this.getMap();
        Collection closeables = mp.values().stream().filter(ii -> ii instanceof AutoCloseable).map(ii -> (AutoCloseable)ii).collect(Collectors.toList());
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.error("\u8d44\u6e90\u91ca\u653e\u53d1\u751f\u5f02\u5e38\uff1a{}", closeable.getClass(), (Object)ex);
            }
        }
        if (mp != null) {
            mp.clear();
            this.setMap(mp);
        }
    }

    public void remove(String key) {
        this.store(key, null);
    }

    public boolean isWebRequest() {
        try {
            return this.servletRequest != null && StringUtils.hasLength((String)this.servletRequest.getRequestURI());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Map<String, Object> getMap() {
        if (this.isWebRequest()) {
            try {
                HashMap<String, Object> mp = (HashMap<String, Object>)this.servletRequest.getAttribute(CURRENT_THREAD_KEY);
                if (mp == null) {
                    mp = new HashMap<String, Object>();
                    this.setMap(mp);
                }
                return mp;
            }
            catch (Exception ex) {
                logger.error("Failed to get map in servletRequest", (Throwable)ex);
            }
        }
        return threadManager.get();
    }

    private void setMap(Map<String, Object> mp) {
        if (this.isWebRequest()) {
            try {
                this.servletRequest.setAttribute(CURRENT_THREAD_KEY, mp);
                return;
            }
            catch (Exception ex) {
                logger.error("Failed to set map in servletRequest", (Throwable)ex);
            }
        }
        threadManager.set(mp);
    }

    static {
        threadManager.set(new HashMap());
    }
}

