/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.CookieProvider;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.web.commons.utils.RequestUtil;
import java.util.function.Supplier;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CookieProviderImpl
implements CookieProvider {
    private static final Logger logger = LoggerFactory.getLogger(CookieProviderImpl.class);
    private final HttpServletResponse response;
    private final HttpServletRequest request;
    private final JsonProvider jsonProvider;

    public CookieProviderImpl(HttpServletResponse response, HttpServletRequest request, JsonProvider jsonProvider) {
        this.response = response;
        this.request = request;
        this.jsonProvider = jsonProvider;
    }

    public void add(String name, String value) {
        String cookieValue = value;
        Cookie cookie = new Cookie(name, cookieValue);
        cookie.setPath("/");
        cookie.setMaxAge(7200);
        this.response.addCookie(cookie);
    }

    public String get(String name) {
        return RequestUtil.getCookieValue(this.request, name);
    }

    public <T> T get(Class<T> tClass, String name, Supplier<T> supplier) {
        assert (supplier != null);
        return supplier.get();
    }
}

