package com.bcxin.web.commons.filters;

import com.bcxin.saas.core.utils.ComponentUtils;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class BasicWebFilter extends OncePerRequestFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String requestUri = httpServletRequest.getRequestURI();
        if(StringUtils.hasLength(requestUri)) {
            if (requestUri.startsWith(String.format("%s/actuator", httpServletRequest.getContextPath())) && !requestUri.contains("health")) {
                httpServletResponse.sendError(HttpServletResponse.SC_NOT_FOUND);
                return;
            }
        }

        if (!ComponentUtils.isFilterIgnored(requestUri)) {
            ThreadContext.put("sessionId", httpServletRequest.getRequestedSessionId());
        }

        filterChain.doFilter(httpServletRequest, httpServletResponse);
    }
}
