package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.SessionProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

@Component
public class DefaultSessionProviderImpl implements SessionProvider {
    @Autowired
    private HttpServletRequest httpServletRequest;

    @Override
    public <T> T getAttribute(String key) {
        try {
            return (T) httpServletRequest.getSession().getAttribute(key);
        } catch (Exception e) {
            //todo 忽略定时任务的错误
        }

        return null;
    }

    @Override
    public <T> void setAttribute(String key, T data) {
        try {
            httpServletRequest.getSession().setAttribute(key, data);
        } catch (Exception ex) {
            //todo 忽略定时任务的错误
        }
    }
}
