package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.CaptchaCodeProvider;
import com.bcxin.saas.core.components.SessionProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.Base64Util;
import org.springframework.stereotype.Component;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;

@Component
public class DefaultCaptchaCodeProviderImpl implements CaptchaCodeProvider {
    private static int WIDTH = 60;
    private static int HEIGHT = 20;

    @Override
    public CaptchaResult getBase64String() {
        // 创建内存图象并获得其图形上下文
        BufferedImage image = new BufferedImage(WIDTH + 6, HEIGHT + 4, BufferedImage.TYPE_INT_RGB);
        Graphics g = null;
        char[] rands = null;
        try {
            g = image.getGraphics();
            // 产生随机的认证码
            rands = generateCheckCode();
            // 产生图像
            drawBackground(g);
            drawRands(g, rands);
        } finally {
            // 结束图像的绘制过程，完成图像
            if (g != null) {
                g.dispose();
            }
        }

        // 转base64
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream()) {// io流

            ImageIO.write(image, "JPG", baos);// 写入流中
            byte[] bytes = baos.toByteArray();// 转换成字节
            String png_base64 = Base64Util.encode(bytes);// 转换成base64串
            // 删除 \r\n
            png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");

            return CaptchaResult.create(String.format("data:image/jpg;base64,%s", png_base64), String.valueOf(rands));
        } catch (IOException ex) {
            throw new SaasBadException("验证码生成失败", ex);
        }
    }

    private char[] generateCheckCode() {
        // 定义验证码的字符表
        // 考虑到1和l难以区分,将l大写为L
        String chars = "0123456789abcdefghijkLmnopqrstuvwxyz";

        char[] rands = new char[4];
        for (int i = 0; i < 4; i++) {
            // int rand = Double.valueOf(Math.random() * 36).intValue();
            int rand = new Random().nextInt(36);
            rands[i] = chars.charAt(rand);
        }

        return rands;
    }

    /**
     * 画干扰背景
     *
     * @param
     */
    private void drawBackground(Graphics gd) {
        // 创建一个随机数生成器类
        Random r = new Random();
        gd.setColor(Color.black);
        gd.clipRect(0, 0, WIDTH + 6, HEIGHT + 4);
        // 画背景
        gd.setColor(Color.white);
        gd.fillRect(1, 1, WIDTH + 4, HEIGHT + 2);
        // 随机产生160条干扰线，使图象中的认证码不易被其它程序探测到。
        for (int i = 0; i < 30; i++) {
            int x = r.nextInt(WIDTH) + 2;
            int y = r.nextInt(HEIGHT) + 3;
            int xl = r.nextInt(12);
            int yl = r.nextInt(12);
            // 产生随机的颜色分量来构造颜色值，这样输出的每位数字的颜色值都将不同。
            int red = r.nextInt(255);
            int green = r.nextInt(255);
            int blue = r.nextInt(255);

            // 用随机产生的颜色将验证码绘制到图像中。
            gd.setColor(new Color(red, green, blue));
            gd.drawLine(x, y, x + xl, y + yl);
        }
    }

    /**
     * 生成图片
     *
     * @param g
     * @param rands
     */
    private void drawRands(Graphics g, char[] rands) {
        g.setColor(new Color(0x1f1f1f));
        // 创建字体，字体的大小应该根据图片的高度来定。
        Font font = new Font("Fixedsys", Font.PLAIN, HEIGHT);
        // 设置字体。
        g.setFont(font);
        int xx = WIDTH / (rands.length + 1);
        int codeY = HEIGHT;
        for (int i = 0; i < rands.length; i++) {
            g.drawString("" + rands[i], (i + 1) * xx, codeY);
        }
    }
}
