/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.saas.logging;

import com.bcxin.saas.core.logs.Logging;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.logging.log4j.core.LogEvent;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class JdbcAppenderConnectionFactory
implements ApplicationContextAware {
    private static DataSource _selectedDataSource;
    private static ApplicationContext applicationContext;

    public static DataSource getUsableDataSource() {
        if (_selectedDataSource == null) {
            Optional<DataSource> dataSourceOptional;
            if (applicationContext == null) {
                return null;
            }
            Map loggingDataSources = applicationContext.getBeansWithAnnotation(Logging.class);
            if (!loggingDataSources.isEmpty() && (dataSourceOptional = loggingDataSources.values().stream().filter(ii -> ii instanceof DataSource).map(ii -> (DataSource)ii).findFirst()).isPresent()) {
                _selectedDataSource = dataSourceOptional.get();
            }
            if (_selectedDataSource == null) {
                _selectedDataSource = (DataSource)applicationContext.getBean("loggerDataSource");
            }
        }
        return _selectedDataSource;
    }

    public static Connection getConnection() throws SQLException {
        DataSource dataSource = JdbcAppenderConnectionFactory.getUsableDataSource();
        if (dataSource == null) {
            return null;
        }
        return dataSource.getConnection();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        JdbcAppenderConnectionFactory.applicationContext = applicationContext;
    }

    public static String getRouteSelectedAppender(LogEvent logEvent, String consoleAppender, String jdbcAppender) {
        return consoleAppender;
    }
}

