package com.bcxin.tenant.domain.snapshots;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collection;

@Data
public class DepartmentImportedItemResultSnapshot implements Serializable {
    private DepartmentImportedItemSnapshot item;
    private Collection<String> invalidLogs;

    public DepartmentImportedItemResultSnapshot() {
    }

    @JsonIgnore
    public boolean getIsSuccess() {
        return CollectionUtils.isEmpty(invalidLogs);
    }

    public static DepartmentImportedItemResultSnapshot create(DepartmentImportedItemSnapshot item, Collection<String> invalidLogs) {
        DepartmentImportedItemResultSnapshot result = new DepartmentImportedItemResultSnapshot();
        result.setItem(item);
        result.setInvalidLogs(invalidLogs);

        return result;
    }
}
