package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class RedoAuthorizationCommand extends CommandAbstract {
    private final String id;
    private final boolean checkAuthenticate;

    public RedoAuthorizationCommand(String id,boolean checkAuthenticate) {
        this.id = id;
        this.checkAuthenticate = checkAuthenticate;
    }

    public static RedoAuthorizationCommand create(String id,boolean checkAuthenticate) {
        return new RedoAuthorizationCommand(id, checkAuthenticate);
    }

    @Override
    public void validate() {
        if(!StringUtils.hasLength(this.getId())) {
            throw new BadTenantException("当前用户Id不能为空");
        }
    }
}
