package com.bcxin.tenant.domain.services.commands.results;

import com.bcxin.tenant.domain.snapshots.DepartmentImportedResultSnapshot;
import lombok.Data;

import java.io.Serializable;

@Data
public class ImportDepartmentCommandResult implements Serializable {
    private String downloadResourceId;
    private DepartmentImportedResultSnapshot result;

    public ImportDepartmentCommandResult(){}


    public ImportDepartmentCommandResult(String downloadResourceId, DepartmentImportedResultSnapshot result) {
        this.downloadResourceId = downloadResourceId;
        this.result = result;
    }


    public static ImportDepartmentCommandResult create(String downloadResourceId, DepartmentImportedResultSnapshot result) {
        return new ImportDepartmentCommandResult(downloadResourceId, result);
    }
}
