package com.bcxin.tenant.domain.services.commands.organizations;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.utils.StringUtils;
import lombok.Getter;

@Getter
public class CreateMyOrganizationCommand extends CommandAbstract {
    //行业类型
    private final String industryCode;

    //机构类型
    private final String institutionalCode;

    //基本信息
    //公司名称
    private final String name;

    private final String unifySocialCreditCode;
    //营业执照附件
    private final String unifySocialCreditCodeFile;

    private final String tenantUserId;

    private final boolean asTeamMember;


    public CreateMyOrganizationCommand(String industryCode, String institutionalCode,
                                       String name,
                                       String unifySocialCreditCode,
                                       String unifySocialCreditCodeFile, String tenantUserId,
                                       boolean asTeamMember) {
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.name = name;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.tenantUserId = tenantUserId;
        this.asTeamMember = asTeamMember;
    }

    @Override
    public void validate() {
        super.validate();
        if (StringUtils.isEmpty(this.getUnifySocialCreditCodeFile())) {
            throw new ArgumentTenantException("营业执照附件不能为空");
        }

        if (StringUtils.isEmpty(this.getName())) {
            throw new ArgumentTenantException("组织名称不能为空");
        }

        if (StringUtils.isEmpty(this.getInstitutionalCode())) {
            throw new ArgumentTenantException("团队类型不能为空");
        }

        if (StringUtils.isEmpty(this.getIndustryCode())) {
            throw new ArgumentTenantException("系统级参数异常-行业类型不可为空");
        }
    }

    public static CreateMyOrganizationCommand create(String industryCode, String institutionalCode,
                                                     String name,
                                                     String unifySocialCreditCode,
                                                     String unifySocialCreditCodeFile, String tenantUserId,
                                                     boolean asTeamMember) {
        return new CreateMyOrganizationCommand(industryCode, institutionalCode, name, unifySocialCreditCode, unifySocialCreditCodeFile, tenantUserId, asTeamMember);
    }
}
