package com.bcxin.tenant.domain.services;

import com.bcxin.tenant.domain.dto.XlcpReportDto;
import com.bcxin.tenant.domain.entities.XlcpEntity;
import com.bcxin.tenant.domain.readers.dtos.EmployeeUserDto;
import com.bcxin.tenant.domain.services.commands.xlcp.CreateXlcpCommand;
import com.bcxin.tenant.domain.services.commands.xlcp.UpdateXlcpCommand;

import java.util.Collection;
import java.util.List;

public interface XlcpService {
    void dispatch(CreateXlcpCommand command);

    void dispatch(List<CreateXlcpCommand> requests);
    void update(List<CreateXlcpCommand> requests);

    void dispatch(UpdateXlcpCommand command);
    void dispatch(String id, String fileUrl);

    int isWithinTheDeadline(String empId);

    Collection<XlcpReportDto> findByEmployeeIdAndProjectName(String employeeId, String projectName);
    Collection<XlcpReportDto> findByThirdPath(int day);
    XlcpReportDto getByserialNumber(String serialNumber);
}
