package com.bcxin.tenant.domain.repositories.dtos;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.Infrastructures.enums.DepartImPermissionType;
import com.bcxin.Infrastructures.utils.StringUtils;
import lombok.Data;

@Data
public class DepartmentDto {
    @ExcelIgnore
    private String id;
    @ExcelIgnore
    private String code;
    @ExcelProperty(value = "部门", index = 0)
    private String name;
    @ExcelIgnore
    private String parentId;
    @ExcelIgnore
    private int level;
    @ExcelProperty(value = "排序", index = 2)
    private int displayOrder;
    @ExcelIgnore
    private DepartImPermissionType permissionType;
    @ExcelIgnore
    private String permissionConfig;
    @ExcelIgnore
    private int totalMember;
    @ExcelIgnore
    private String indexTree;
    @ExcelProperty(value = "上级部门", index = 1)
    private String parent;


    public DepartmentDto(String id, String code, String name, String parentId, int level,
                         long totalMember,
                         int displayOrder, DepartImPermissionType permissionType, String permissionConfig,String indexTree) {
        this.setId(id);
        this.setCode(code);
        this.setName(name);
        this.setParentId(parentId);
        this.setLevel(level);
        this.setDisplayOrder(displayOrder);
        this.setPermissionType(permissionType);
        this.setPermissionConfig(permissionConfig);
        this.setTotalMember((int) totalMember);
        this.setIndexTree(indexTree);
        if (!StringUtils.isEmpty(indexTree)) {
            this.setParent(indexTree.replace("-" + id, ""));
        }
    }

    public void resetIndexTree(String indexTree) {
        this.setIndexTree(indexTree);
    }
}
