package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;

import java.util.Collection;
import java.util.Optional;

public interface TenantEventRepository extends EntityRepository<TenantEventEntity,String> {
    Collection<TenantEventEntity> getEvents(Long startVersion, Collection<String> mapKeys);

    Optional<TenantEventEntity> getByUserId(String tenantUserId);

    Optional<TenantEventEntity> getPendingByContent(String content, EventAction action);

    Optional<TenantEventEntity> getByContent(String content);

    Collection<TenantEventEntity> getEventsByUserId(String tenantUserId);

    Collection<TenantEventEntity> getByUserIdAndAction(String tenantUserId, EventAction action);
}
