package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.tenant.domain.entities.SysIndustryTypeEntity;

import java.util.Collection;

public interface SysIndustryTypeRepository extends EntityRepository<SysIndustryTypeEntity, String> {

    /**
     * 根据是否删除状态查询行业类型列表
     * @param isDeleted 是否删除(0-未删除,1-已删除)
     * @return 行业类型列表
     */
    Collection<SysIndustryTypeEntity> findByIsDeleted(Integer isDeleted);

    /**
     * 根据行业编码查询行业类型
     * @param code 行业编码
     * @param isDeleted 是否删除(0-未删除,1-已删除)
     * @return 行业类型
     */
    SysIndustryTypeEntity findByCodeAndIsDeleted(String code, Integer isDeleted);
}


