package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.entities.EmployeeEntity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface EmployeeRepository extends EntityRepository<EmployeeEntity, String> {

    Collection<EmployeeEntity> getByIds(String organizationId, Collection<String> ids);

    int replaceSuperior(String organizationId, String originalId, String newId);

    EmployeeEntity getByOrganIdAndId(String organizationId, String id);

    Collection<EmployeeEntity> getByIdNums(String organizationId, Collection<String> idNums);

    Collection<EmployeeEntity> getByTelephones(String organizationId, Collection<String> telephones);

    EmployeeEntity getByTelephone(String organizationId, String telephone);

    EmployeeEntity getByIdNum(String organizationId, String idNum);

    Collection<EmployeeEntity> getSecurityGuardsByTenantUserId(String tenantUserId);

    Collection<EmployeeEntity> getRegisterEmployeeByOrganId(String organizationId);

    Collection<EmployeeEntity> getAllByOrganId(String organizationId);


    /**
     * 根据投保状态和用户id获取用户id
     *
     * @return {@link Collection}<{@link String}>
     */
    Collection<String> queryIdByNotIsSure(Collection<String> ids);


    /**
     * 获取投保过期的用户
     *
     * @param ids    id
     * @return {@link Collection}<{@link String}>
     */
    Collection<String> queryIdByFailureIsSure(Collection<String> ids);


    /**
     * 获取投保过期的用户
     *
     * @param ids    id
     * @return {@link Collection}<{@link String}>
     */
    Collection<String> queryIdBySuccessIsSure(Collection<String> ids);

    /**
     * 更新投保状态
     *
     * @param ids    id
     * @param status 状态
     */
    void updateIsSureStatus(Collection<String> ids, TrueFalseStatus status);

    List<EmployeeEntity> getAllByIdNums(Collection<String> idNums);

    List<EmployeeEntity> getAllByTelephones(Collection<String> telephones);

    List<EmployeeEntity> getSecurityGuardByIdNums(Collection<String> idNums);

    void updateRelativeDepartmentIndexCodeByIds(String departId,String newIndexTreeCode);

    List<String> findIdListByDepartmentIndexTree(String departmentIndexTree);

    List<EmployeeEntity> getAdminByOrganId(String organizationId);

    boolean checkIfExists(String organizationId,String tenantUserId);

    String getByOrgIdAndUserId(String organizationId, String tenantUserId);

    EmployeeEntity getIdByOrgIdAndIdCard(String organizationId, String idCardNo);

    List<String> findJuniorNameListBySuperiorId(Collection<String> superiorId);
}
