package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
/**
 * <b> 心理测评 </b>
 * @author ZXF
 * @create 2025/03/18 0018 17:05
 * @version
 * @注意事项 </b>
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_xlcp")
@Entity
public class XlcpEntity extends OpEntityAbstract implements IAggregate {

    @Id
    private String id;

    /**
     * 业务编码
     */
    @Column(name = "serial_number")
    private String serialNumber;

    /**
     * 姓名
     */
    @Column(name = "name")
    private String name;

    /**
     * 证件号码
     */
    @Column(name = "number")
    private String number;

    /**
     * 测评项目名称
     */
    @Column(name = "project_name")
    private String projectName;

    @Column(name = "employee_id")
    private String employeeId;

    @Column(name = "organization_id")
    private String organizationId;

    /**
     * 工会id
     */
    @Column(name = "union_id")
    private String unionId = "216cb2144e46f326a4e6e6081e93dbd5f9c0c01c5e3a5ad0e6b92e28c43dccd4";

    /**
     * 附件
     */
    @Column(name = "file_url")
    private String fileUrl;

    /**
     * 建议
     */
    @Column(name = "suggestion")
    private String suggestion;

    /**
     * 评语
     */
    @Column(name = "content")
    private String content;

    /**
     * 测评结果
     */
    @Column(name = "result")
    private String result;

    /**
     * 结果规则提示
     */
    @Column(name = "result_rule_tip")
    private String resultRuleTip;

    public XlcpEntity() {
        super();
    }

    public void change(String fileUrl, String suggestion, String content) {
        this.setFileUrl(fileUrl);
        this.setSuggestion(suggestion);
        this.setContent(content);
    }

    /**
     * @param serialNumber
     * @param projectName
     * @param organization
     * @param employee
     * @param name
     * @param number
     * @param fileUrl
     * @param suggestion
     * @param content
     * @param result
     * @param resultRuleTip
     * @return
     */
    public static XlcpEntity create(
            String serialNumber, String projectName,
            String organizationId,
            String employeeId, String name, String number, String fileUrl, String suggestion, String content, String result, String resultRuleTip) {
        XlcpEntity xlcp = new XlcpEntity();
        xlcp.setId(UUIDUtil.getShortUuid());
        xlcp.setSerialNumber(serialNumber);
        xlcp.setName(name);
        xlcp.setProjectName(projectName);
        xlcp.setEmployeeId(employeeId);
        xlcp.setOrganizationId(organizationId);
        xlcp.setName(name);
        xlcp.setNumber(number);
        xlcp.setFileUrl(fileUrl);
        xlcp.setSuggestion(suggestion);
        xlcp.setContent(content);
        xlcp.setResult(result);
        xlcp.setResultRuleTip(resultRuleTip);
        return xlcp;
    }
}
