package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.Date;

/**
 * description：用户信息拓展表
 * author：linchunpeng
 * date：2025/5/21
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "tenant_user_extension")
@Entity
@Data
public class TenantUserExtensionEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 用户id
     */
    @Column(name = "tenant_user_id")
    private String tenantUserId;

    /**
     * 拓展信息的key
     */
    @Column(name = "extension_key")
    private String extensionKey;

    /**
     * 拓展信息的value
     */
    @Column(name = "extension_value")
    private String extensionValue;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 修改时间
     */
    @Column(name = "update_time")
    private Date updateTime;

}
