package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Timestamp;

/**
 * 机构类型表
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "sys_institutional_types")
@Entity
public class SysInstitutionalTypeEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键ID
     */
    @Id
    @Column(name = "id", nullable = false, length = 50)
    private String id;

    /**
     * 机构类型编码
     */
    @Column(name = "code", nullable = false, length = 50)
    private String code;

    /**
     * 机构类型名称
     */
    @Column(name = "name", nullable = false, length = 100)
    private String name;

    /**
     * 标签，多个用逗号分隔
     */
    @Column(name = "tags", length = 255)
    private String tags;

    /**
     * 所属行业ID，关联sys_industry_types表
     */
    @Column(name = "industry_id", nullable = false, length = 50)
    private String industryId;

    /**
     * 创建时间
     */
    @Column(name = "created_at", nullable = false)
    private Timestamp createdAt;

    /**
     * 更新时间
     */
    @Column(name = "updated_at", nullable = false)
    private Timestamp updatedAt;

    /**
     * 是否删除(0-未删除,1-已删除)
     */
    @Column(name = "is_deleted", nullable = false)
    private Integer isDeleted;

}


