package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;


/**
 * description: 监管机构表
 * author: linchunpeng
 * date:  2023-05-09 18:02
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "t_supervise_department")
@Entity
@Data
public class SuperviseDepartmentEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键
     */
    @Id
    @Column(name = "pk_id")
    private Long pkId;

    /**
     * id
     */
    @Column(name = "id")
    private String id;

    /**
     * 名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 上级编码
     */
    @Column(name = "superior")
    private String superior;

    /**
     * 状态
     */
    @Column(name = "status")
    private String status;

    /**
     * 层级
     */
    @Column(name = "index_code")
    private String indexCode;

    /**
     * 地区id
     */
    @Column(name = "region_id")
    private String regionId;

    /**
     * 行业代码
     */
    @Column(name = "industry_code")
    private String industryCode;

}
