package com.bcxin.rest.web.apis.requests;

import com.bcxin.Infrastructures.utils.JwtUtil;
import lombok.Data;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

@Data
public class ChangePasswordRequest {
    @NotEmpty
    private String userName;
    @NotEmpty
    private String password;
    @NotEmpty
    private String newPassword;
    @NotEmpty
    private String confirmedPassword;

    public com.bcxin.api.interfaces.identities.requests.ChangePasswordRequest getRequest(
            HttpServletRequest request) {
        com.bcxin.api.interfaces.identities.requests.ChangePasswordRequest changePasswordRequest =
                new com.bcxin.api.interfaces.identities.requests.ChangePasswordRequest();
        changePasswordRequest.setPassword(this.getPassword());
        changePasswordRequest.setNewPassword(this.getNewPassword());
        changePasswordRequest.setConfirmedPassword(this.getConfirmedPassword());
        changePasswordRequest.setUserName(this.getUserName());
        String authorizationToken = request.getHeader("Authorization");

        String token = "";
        if (StringUtils.hasLength(authorizationToken) && authorizationToken.contains("Bearer ")) {
            token = authorizationToken.substring(7);
        }

        String identityUserId = JwtUtil.getContentFromToken(token);
        changePasswordRequest.setIdentityUserId(identityUserId);

        return changePasswordRequest;
    }
}
