package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.identities.requests.*;
import com.bcxin.api.interfaces.tenants.RegisterRpcProvider;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/tenant/register")
public class RegisterController extends ControllerAbstract {

    private final Logger logger = LoggerFactory.getLogger(RegisterController.class);

    private final RegisterRpcProvider registerRpcProvider;

    public RegisterController(RegisterRpcProvider registerRpcProvider) {
        this.registerRpcProvider = registerRpcProvider;
    }

    @ApiOperation(value = "自然人注册")
    @PostMapping("/{areaCode}/legal")
    public ResponseEntity naturalPersonRegister(@PathVariable("areaCode") String areaCode,@RequestBody UserRegisterRequest request){
        try {
            request.setAreaCode(areaCode);
            registerRpcProvider.saveLoginUser(request);
            return this.ok();
        } catch (Exception e) {
            return this.error(e.getMessage());
        }
    }

}
