package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.api.interfaces.tenants.ExternalMemberRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.externalMembers.ExternalMemberSearchRequest;
import com.bcxin.api.interfaces.tenants.requests.externalMembers.UpdateExternalMemberRequest;
import com.bcxin.api.interfaces.tenants.requests.externalMembers.UpdateExternalMemberStatusRequest;
import com.bcxin.api.interfaces.tenants.responses.ExternalMemberSearchResponse;
import io.swagger.annotations.*;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.IOException;
import java.util.Collection;

@Api("当前团体的人员信息")
@RestController
@RequestMapping("/organizations/{organizationId}")
public class OrganizationExternalMemberController extends ControllerAbstract{
    private final RedisTemplate redisTemplate;
    private final JsonProvider jsonProvider;

    private final ExternalMemberRpcProvider externalMemberRpcProvider;

    public OrganizationExternalMemberController(RedisTemplate redisTemplate,
                                                JsonProvider jsonProvider,
                                                ExternalMemberRpcProvider externalMemberRpcProvider) {
        this.redisTemplate = redisTemplate;
        this.jsonProvider = jsonProvider;
        this.externalMemberRpcProvider = externalMemberRpcProvider;
    }

    @ApiImplicitParams({
            @ApiImplicitParam(
                    name = "Authorization",
                    value = "Bearer 租户token",
                    paramType = "header",
                    dataType = "String"
            )
    })
    @ApiOperation("查询所有的团体成员")
    @ApiResponses({
            @ApiResponse(code = 200, message = "无", response = Valid.class),
            @ApiResponse(code = 404, message = "当前用户无效", response = Valid.class)
    })
    @PostMapping("/external-members/search")
    public ResponseEntity<Collection<ExternalMemberSearchResponse>> search(
            @PathVariable String organizationId,
            @RequestBody ExternalMemberSearchRequest request,
            HttpServletResponse response) throws IOException {
        Collection<ExternalMemberSearchResponse> data = this.externalMemberRpcProvider.search(request);

        return this.ok(data);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(
                    name = "Authorization",
                    value = "Bearer 租户token",
                    paramType = "header",
                    dataType = "String"
            )
    })
    @ApiOperation("批量操作-审批通过/删除")
    @ApiResponses({
            @ApiResponse(code = 200, message = "无", response = Valid.class),
            @ApiResponse(code = 404, message = "当前用户无效", response = Valid.class)
    })
    @PostMapping("/external-members/batch-action")
    public ResponseEntity batchAction(
            @PathVariable String organizationId,
            @RequestBody UpdateExternalMemberStatusRequest request,
            HttpServletResponse response) throws IOException {
        this.externalMemberRpcProvider.updateStatus(request);

        return this.ok();
    }

    @ApiImplicitParams({
            @ApiImplicitParam(
                    name = "Authorization",
                    value = "Bearer 租户token",
                    paramType = "header",
                    dataType = "String"
            )
    })
    @ApiOperation("批量转移人员所在的组")
    @ApiResponses({
            @ApiResponse(code = 200, message = "无", response = Valid.class),
            @ApiResponse(code = 404, message = "当前用户无效", response = Valid.class)
    })
    @PostMapping("/external-members/batch-move")
    public ResponseEntity batchMove(
            @PathVariable String organizationId,
            @RequestBody UpdateExternalMemberRequest request,
            HttpServletResponse response) throws IOException {
        this.externalMemberRpcProvider.update(request);

        return this.ok();
    }
}
