package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.api.interfaces.tenants.OrganizationAdminRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationAdminCriteria;
import com.bcxin.api.interfaces.tenants.requests.orgainzaitionAdmins.CreateOrganizationAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.orgainzaitionAdmins.DeleteOrganizationAdminRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationAdminResponse;
import com.bcxin.rest.web.apis.utils.CacheUtil;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RequestMapping("/tenant/organizations/{organizationId}/admin")
@RestController
public class OrganizationAdminController extends ControllerAbstract{
    private final OrganizationAdminRpcProvider organizationAdminRpcProvider;
    private final CacheV2Provider cacheV2Provider;

    public OrganizationAdminController(OrganizationAdminRpcProvider organizationAdminRpcProvider,CacheV2Provider cacheV2Provider) {
        this.organizationAdminRpcProvider = organizationAdminRpcProvider;
        this.cacheV2Provider= cacheV2Provider;
    }

    @PostMapping
    public ResponseEntity post(@PathVariable String organizationId, @RequestBody CreateOrganizationAdminRequest request) {
        this.organizationAdminRpcProvider.create(organizationId, request);
        CacheUtil.clearCurrentOrganizationsCache(cacheV2Provider);
        return this.ok();
    }

    @DeleteMapping
    public ResponseEntity delete(@PathVariable String organizationId, @RequestBody DeleteOrganizationAdminRequest request) {
        this.organizationAdminRpcProvider.delete(organizationId, request);
        CacheUtil.clearCurrentOrganizationsCache(cacheV2Provider);

        return this.ok();
    }

    @PostMapping("/search")
    public ResponseEntity<Pageable<OrganizationAdminResponse>> search(@PathVariable String organizationId, @RequestBody OrganizationAdminCriteria criteria) {
        Pageable<OrganizationAdminResponse> responsePageable =
                this.organizationAdminRpcProvider.search(organizationId, criteria);

        return this.ok(responsePageable);
    }
}
