package com.bcxin.rest.web.apis.controllers;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.api.interfaces.commons.DownloadImportedResponse;
import com.bcxin.api.interfaces.commons.responses.CompanyResponse;
import com.bcxin.api.interfaces.tenants.OrganizationRpcProvider;
import com.bcxin.api.interfaces.tenants.ResourceRpcProvider;
import com.bcxin.rest.web.apis.constants.ReportConstants;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@RequestMapping("/download/resources/{resourceId}")
@RestController
public class DownloadController extends ControllerAbstract {
    private static Map<String, InputStream> _staticTemplateResource = new ConcurrentHashMap<>();
    private final ResourceRpcProvider resourceRpcProvider;
    private final OrganizationRpcProvider organizationRpcProvider;

    public DownloadController(ResourceRpcProvider resourceRpcProvider, OrganizationRpcProvider organizationRpcProvider) {
        this.resourceRpcProvider = resourceRpcProvider;
        this.organizationRpcProvider = organizationRpcProvider;
    }

    @GetMapping("/{category}")
    public void download(HttpServletResponse response,
                         @PathVariable String resourceId,
                         @PathVariable String category) throws IOException {
        response.setContentType("application/vnd.ms-excel");// 设置文本内省
        response.setCharacterEncoding("utf-8");// 设置字符编码
        DownloadImportedResponse result = this.resourceRpcProvider.getImportResult(resourceId, category);
        String fileName = String.format("%s.xlsx", UUID.randomUUID());
        if (StringUtils.hasLength(result.getPath())
                && result.getPath().contains("/")
                && result.getPath().contains(".")
                && result.getPath().lastIndexOf("/") + 1 < result.getPath().lastIndexOf(".")) {
            fileName = result.getPath().substring(result.getPath().lastIndexOf("/") + 1, result.getPath().lastIndexOf("."));
        }

        String disposition = String.format("attachment;filename=%s.xlsx", URLEncoder.encode(fileName, "UTF-8"));
        response.setHeader("Content-disposition", disposition);

        Collection<Map<String, Object>> errorItems = result.getReport().stream().filter(ii -> !ii.IsSuccess())
                .map(ii -> ii.getParameters())
                .collect(Collectors.toList());

        String industryCode = null;
        String institutionalCode = null;
        if (StringUtils.hasLength(result.getOrganizationId())) {
            CompanyResponse companyResponse = organizationRpcProvider.get(result.getOrganizationId());
            industryCode = companyResponse.getIndustryCode();
            institutionalCode = companyResponse.getInstitutionalCode();
        }

        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(getCategoryTemplate(category, industryCode, institutionalCode))) {
            ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream())
                    .withTemplate(inputStream).build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(false)
                    .build();
            excelWriter.fill(errorItems, fillConfig, EasyExcel.writerSheet().build());

            excelWriter.finish();
            response.flushBuffer();
        }
    }

    private static String getCategoryTemplate(String category, String industryCode, String institutionalCode) {
        switch (category) {
            case ReportConstants.DEPARTMENT:
                return "templates/V5部门导入模板2021.xlsx";
            case ReportConstants.EMPLOYEE:
                if (StringUtils.hasLength(institutionalCode)
                        && (institutionalCode.endsWith("07")
                        || institutionalCode.endsWith("08")
                        || institutionalCode.endsWith("09"))) {
                    //监管组织
                    return "templates/V5_jg_在职员工导入模板2023.xlsx";
                }
                if ("02,04,06,07".contains(industryCode)) {
                    //大活行业、群防群治行业、内保行业、行业主管部门
                    String code = industryCode;
                    if (code.equals("07")) {
                        //行业主管部门与内保行业公用一个模板
                        code = "04";
                    }
                    return "templates/V5_"+code+"_在职员工导入模板2023.xlsx";
                }
                return "templates/V5在职员工导入模板2023.xlsx";
            case ReportConstants.CONTRACT:
                return "templates/V5合同导入模板2021.xlsx";
            case ReportConstants.EMPLOYEE_LEAVE:
                return "templates/V5离职员工导入模板2022.xlsx";
        }

        throw new ArgumentTenantException("无效参数");
    }
}
