package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.Infrastructures.utils.StringUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class UserCredentialResponse implements Serializable {

    /**
     * 姓名
     */
    private String name;
    /**
     * 证件编号
     */
    private String credentialNumber;
    /**
     * 证件类型
     */
    private String credentialType;
    /**
     * 发证机关
     */
    private String fzjgmc;
    /**
     * 发证日期
     */
    private String fzrq;
    /**
     * 手机号码
     */
    private String telephone;
    /**
     * 转换后的核验状态：中文
     */
    private String checkedStatus;
    /**
     * 实名认证状态:中文
     */
    private String authenticatedStatus;
    /**
     * 身份证
     */
    private String identityNumber;
    /**
     * 一寸免冠照
     */
    private String headPhoto;
    /**
     * 证件地址
     */
    private String reversePhoto;
    /**
     * 资格证pdf地址
     */
    private String frontPhoto;
    /**
     * 户籍地址
     */
    private String address;

    public String getSex()
    {
        if(StringUtils.isEmpty(this.getIdentityNumber())) {
            return "未知";
        }

        if(this.getIdentityNumber().length()<15) {
            return "未知";
        }

        String cardNo = this.getIdentityNumber();
        String sexStr = "";
        if (cardNo.length() == 15) {
            sexStr = cardNo.substring(14, 15);
        } else if (cardNo.length() == 18) {
            sexStr = cardNo.substring(16, 17);
        }
        int sexNo = Integer.parseInt(sexStr);
        String sex = sexNo % 2 == 0 ? "女" : "男";
        return sex;
    }

    public UserCredentialResponse() {
    }

    public UserCredentialResponse(String name, String credentialNumber, String credentialType, String fzjgmc, String fzrq, String telephone, String checkedStatus, String authenticatedStatus, String identityNumber, String headPhoto,String reversePhoto, String frontPhoto, String address) {
        this.name = name;
        this.credentialNumber = credentialNumber;
        this.credentialType = credentialType;
        this.fzjgmc = fzjgmc;
        this.fzrq = fzrq;
        this.telephone = telephone;
        this.checkedStatus = checkedStatus;
        this.authenticatedStatus = authenticatedStatus;
        this.identityNumber = identityNumber;
        this.headPhoto = CdnUtils.convert(headPhoto);
        this.reversePhoto = CdnUtils.convert(reversePhoto);
        this.frontPhoto = CdnUtils.convert(frontPhoto);
        this.address = address;
    }

    public static UserCredentialResponse create(String name, String credentialNumber, Integer credentialType, String fzjgmc, Date fzrq, String telephone, Integer checkedStatus, Integer authenticatedStatus, String idnum, String headPhoto, String reversePhoto, String frontPhoto, String address) {
        return new UserCredentialResponse(name,credentialNumber,
                getCredentialType(credentialType),fzjgmc,
                fzrq != null ? DateUtil.format2ShortDate(fzrq) : null
                ,telephone,
                getCheckedStatus(checkedStatus),getAuthenticatedStatus(authenticatedStatus),
                idnum,headPhoto,reversePhoto,frontPhoto,address);
    }

    private static String getCheckedStatus(Integer checkedStatus){
        String name = null;
        if (checkedStatus != null){
            for (UserCheckedStatus value : UserCheckedStatus.values()) {
                if (value.ordinal() == checkedStatus.intValue()){
                    name = value.getTypeName();
                    break;
                }
            }
        }
        return name;
    }

    private static String getCredentialType(Integer credentialType){
        String name = null;
        if (credentialType != null){
            for (CredentialType value : CredentialType.values()) {
                if (value.ordinal() == credentialType){
                    name = value.getTypeName();
                    break;
                }
            }
        }
        return name;
    }

    private static String getAuthenticatedStatus(Integer authenticatedStatus){
        String name = null;
        if (authenticatedStatus != null){
            for (RealNameAuthenticatedStatus value : RealNameAuthenticatedStatus.values()) {
                if (value.ordinal() == authenticatedStatus.intValue()){
                    name = value.getTypeName();
                    break;
                }
            }
        }
        return name;
    }
}
