package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.StringUtils;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.text.SimpleDateFormat;
import java.util.Date;

@ApiModel("入离职记录信息")
@Getter
public class EmployeeRecordResponse extends ResponseAbstract {
    @ApiModelProperty("当前的用户id")
    private String tenantUserId;
    @ApiModelProperty("姓名")
    private String name;
    @ApiModelProperty("证件类型")
    private String credentialType;
    @ApiModelProperty("证件号码")
    private String credentialNumber;
    @ApiModelProperty("职业类型")
    private String occupationType;

    @ApiModelProperty("入/离/复职时间")
    private String actionTime;
    @ApiModelProperty("入/离职状态")
    private String status;
    @ApiModelProperty("备注")
    private String actionNode;
    @ApiModelProperty("操作人")
    private String operatorName;
    @ApiModelProperty("操作时间")
    private String operatorTime;

    public EmployeeRecordResponse(){}


    public EmployeeRecordResponse(String tenantUserId, String name, CredentialType credentialType,
                                  String credentialNumber, OccupationType occupationType,
                                  Date actionTime, EmploymentStatus status,
                                  String actionNode, String operatorName,
                                  Date operatorTime) {
        this.tenantUserId = tenantUserId;
        this.name = name;
        this.credentialType = credentialType.getTypeName();
        this.credentialNumber = credentialNumber;
        this.occupationType = occupationType.getTypeName();
        this.status = status == EmploymentStatus.OnJob ? "入职" : "离职";
        if(org.springframework.util.StringUtils.hasLength(actionNode) &&
                (actionNode.contains("补充离职信息") || actionNode.contains("补充入职信息") || "补充信息".equalsIgnoreCase(actionNode))) {
            this.actionNode = "";
        }else {
            this.actionNode = actionNode;
        }

        this.operatorName = operatorName;

        if (actionTime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.actionTime = dateFormat.format(actionTime);
        }

        /**
         * 针对旧数据; 无操作人的时候，不显式操作时间
         */
        if (!StringUtils.isEmpty(this.operatorName) && operatorTime != null) {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.operatorTime = dateTimeFormat.format(operatorTime);
        }
    }

    public static EmployeeRecordResponse create(String tenantUserId, String name, CredentialType credentialType,
                                                String credentialNumber, OccupationType occupationType,
                                                Date actionTime, EmploymentStatus status,
                                                String actionNode, String operatorName,
                                                Date operatorTime) {
        return new EmployeeRecordResponse(tenantUserId, name, credentialType, credentialNumber,
                occupationType, actionTime, status, actionNode, operatorName, operatorTime);
    }
}
