package com.bcxin.api.interfaces.tenants.requests.externalMembers;

import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.enums.ExternalMemberInviteType;
import lombok.Getter;

@Getter
public class CreateExternalMemberRequest extends RequestAbstract {
    private final String organizationId;
    private final String invitorId;
    private final String groupId;

    private final ExternalMemberInviteType inviteType;

    private final String inviteCode;

    public CreateExternalMemberRequest(ExternalMemberInviteType inviteType, String inviteCode, String organizationId, String invitorId, String groupId) {
        this.organizationId = organizationId;
        this.invitorId = invitorId;
        this.groupId = groupId;

        this.inviteType = inviteType;
        this.inviteCode = inviteCode;
    }

    public static CreateExternalMemberRequest create(ExternalMemberInviteType inviteType, String inviteCode,String organizationId, String invitorId, String groupId){
        return new CreateExternalMemberRequest(inviteType,inviteCode, organizationId,invitorId,groupId);
    }
}
