package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.commons.responses.CompanyInfoCompleteResponse;
import com.bcxin.api.interfaces.commons.responses.CompanyNameExistResponse;
import com.bcxin.api.interfaces.commons.responses.CompanyPromoterResponse;
import com.bcxin.api.interfaces.commons.responses.CompanyResponse;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria;
import com.bcxin.api.interfaces.tenants.requests.organizations.*;
import com.bcxin.api.interfaces.tenants.responses.*;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Component
public interface OrganizationRpcProvider {
    void notifyMessage(String id,String eventId);
    TenantOrganizationResponse getOrganizationReqewsts(String number);
    String register(CompanyRegistrationRequest request);

    CompanyResponse get(String id);

    Collection<OrganizationAppGetResponse> getOrganApps(String id);

    Collection<String> getApps(String id);

    void approve(String id, ApproveCompanyRequest request);

    Pageable<OrganizationResponse> search(OrganizationCriteria criteria);

    void approvedUpdate(CompanyApprovedUpdateRequest request);

    void update(CompanyUpdateRequest request);

    /**
     * description：判断企业名称是否存在
     * author：linchunpeng
     * date：2023/12/7
     */
    CompanyNameExistResponse nameExist(String name);

    /**
     * description: 判断企业信息是否完善
     * author: linchunpeng
     * date:  2023-05-22 11:47
     */
    CompanyInfoCompleteResponse infoComplete(String organizationId);

    List<OrganizationExactSearchResponse> exactSearch(OrganizationRequest request);

    CompanyPromoterResponse isOrganizationPromoter(String id);

    CompanyResponse getDetail(String organizationId);

    String createOrgExcel(com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria criteria) throws Exception;

    Pageable<CompanyCredentialResponse> getCompanies(OrganizationCriteria queryRequest);

    void create(CreateOrganizationRequest request);

    Collection<MyRegistrationOrganizationResponse> getMyRegistrationOrganizations(int pageIndex,int pageSize);
}
