package com.bcxin.api.interfaces.rbacs.custom;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.rbacs.custom.request.*;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacCustomRoleResponse;
import com.bcxin.api.interfaces.rbacs.custom.response.RbacUserResponse;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchImportRoleMemberRequest;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Map;

@Component
public interface RbacCustomRoleManagerProvider {

    /**
     * description：根据企业id，查询企业自定义角色列表
     * author：linchunpeng
     * date：2024/2/1
     */
    List<RbacCustomRoleResponse> findOrgRoleList(RbacCustomRoleSearchRequest searchRequest);

    /**
     * description：分页查询用户职员列表
     * author：linchunpeng
     * date：2024/2/3
     */
    Pageable<RbacUserResponse> getRbacUserDtoList(RbacUserSearchRequest request);

    /**
     * description：企业新增角色
     * author：linchunpeng
     * date：2024/2/2
     */
    void addRole(RbacCustomRoleAddRequest request);

    /**
     * description：企业编辑角色
     * author：linchunpeng
     * date：2024/2/2
     */
    void editRole(RbacCustomRoleEditRequest request);

    /**
     * description：根据id查询角色详情
     * author：linchunpeng
     * date：2024/2/2
     */
    RbacCustomRoleResponse findById(Long id);

    /**
     * description：根据id复制角色
     * author：linchunpeng
     * date：2024/2/2
     */
    void copyRole(RbacCustomRoleAddRequest request);

    /**
     * description：根据id列表删除角色
     * author：linchunpeng
     * date：2024/2/2
     */
    void deleteRole(IdListRequest request);

    /**
     * description：根据角色id、职员id列表，批量设置用户关联
     * author：linchunpeng
     * date：2024/2/2
     */
    void addRoleAndUsers(RbacCustomRoleIdEmployeeIdListRequest request);

    /**
     * description：根据职员id、角色id列表，批量设置角色关联
     * author：linchunpeng
     * date：2024/2/2
     */
    void addUserAndRoles(RbacCustomEmployeeIdRoleIdListRequest request);

    /**
     * description：根据职员id列表、角色id列表，批量设置角色关联
     * author：linchunpeng
     * date：2024/3/5
     */
    void addUsersAndRoles(RbacCustomRoleIdListEmployeeIdListRequest request);

    /**
     * description：根据角色id、职员id列表，批量删除用户关联
     * author：linchunpeng
     * date：2024/2/2
     */
    void deleteRoleAndUsers(RbacCustomRoleIdEmployeeIdListRequest request);

    /**
     * description：根据职员id、角色id列表，批量删除用户关联
     * author：linchunpeng
     * date：2024/2/2
     */
    void deleteUserAndRoles(RbacCustomEmployeeIdRoleIdListRequest request);

    /**
     * description：根据角色id和职员id列表，查询角色用户关联列表
     * author：linchunpeng
     * date：2024/2/2
     */
    List<RbacUserResponse> findRoleUserListByRoleIdAndEmployeeIdList(Long roleId, List<String> employeeIdList);

    /**
     * description：批量导入角色成员
     * author：linchunpeng
     * date：2024/2/6
     */
    List<Map<String, String>> importMember(String organizationId, Long roleId, Collection<BatchImportRoleMemberRequest> requests);
}
