package com.bcxin.api.interfaces.identities.requests;

import com.bcxin.Infrastructures.exceptions.BadTenantException;
import lombok.Data;
import org.apache.http.cookie.Cookie;
import org.springframework.util.StringUtils;

import java.io.UnsupportedEncodingException;

@Data
public class CALoginRequest extends PasswordRequestAbstract {

    private String userName;

    public void setUserNameForBJCA(String dnname){
        try {
            if(!StringUtils.isEmpty(this.userName)) {
                return;
            }
            //北京CA认证
            if(!StringUtils.isEmpty(dnname)) {
                String name = new String(dnname.getBytes("ISO8859-1"),"UTF-8");
                for (String data : name.split(",")) {
                    String[]datas = data.split("=");
                    if("CN".equals(datas[0].trim())){
                        String userInfo = datas[1].trim();
                        //获取身份证号
                        this.userName = userInfo.split(" ")[1];
                    }
                }
            }
        } catch (Exception e) {
            throw new BadTenantException(String.format("北京数字证书异常;Exception=%s", e.toString()));
        }
    }

    public void setUserNameForHNCA(String userName){
        char[] chars = userName.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            if (Character.isDigit(chars[i])) {
                this.userName = userName.substring(i);
                break;
            }
        }

    }
}
