/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class RetirementAgeUtil {
    public static LocalDate calculateRetirementDate(LocalDate birthDate, int originalRetirementAge) {
        LocalDate policyStartDate = LocalDate.of(2025, 1, 1);
        LocalDate originalRetirementDate = birthDate.plusYears(originalRetirementAge);
        long monthsBetween = ChronoUnit.MONTHS.between(policyStartDate, originalRetirementDate) + 1L;
        long daysBetween = ChronoUnit.DAYS.between(policyStartDate, originalRetirementDate);
        if (daysBetween < 0L) {
            return originalRetirementDate;
        }
        int monthsToAdd = 0;
        switch (originalRetirementAge) {
            case 55: 
            case 60: {
                monthsToAdd = (int)Math.ceil((double)monthsBetween / 4.0);
                if (monthsToAdd <= 36) break;
                monthsToAdd = 36;
                break;
            }
            case 50: {
                monthsToAdd = (int)Math.ceil((double)monthsBetween / 2.0);
                if (monthsToAdd <= 60) break;
                monthsToAdd = 60;
                break;
            }
        }
        return originalRetirementDate.plusMonths(monthsToAdd);
    }

    public static boolean isExceedRetirementAge(Date birthDate, int originalRetirementAge) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String formattedDate = formatter.format(birthDate);
        LocalDate localDate = LocalDate.parse(formattedDate);
        LocalDate retirementDate = RetirementAgeUtil.calculateRetirementDate(localDate, originalRetirementAge);
        return retirementDate.isBefore(LocalDate.now());
    }
}

