/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.enums;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.IdcardUtil;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.RetirementAgeUtil;
import com.bcxin.Infrastructures.validations.CredentialValidator;
import com.bcxin.Infrastructures.validations.DateValidator;
import java.util.Date;
import org.springframework.util.StringUtils;

public enum OccupationType {
    Normal{

        @Override
        public String getTypeName() {
            return "\u4e00\u822c\u804c\u5458";
        }

        @Override
        public void validate(CredentialType credentialType, String number, String areaCode, String institutionalCode) {
            super.validate(credentialType, number, areaCode, institutionalCode);
            if (!(institutionalCode != null && institutionalCode.startsWith("02") || credentialType != CredentialType.IdCard)) {
                Date d = new Date();
                DateTime birthDate = IdcardUtil.getBirthDate((String)number);
                if (DateValidator.dateAddYear((Date)birthDate, 18).after(d)) {
                    throw new ArgumentTenantException("\u4e00\u822c\u804c\u5458, \u5e74\u9f84\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e18\u5c81");
                }
            }
        }
    }
    ,
    SecurityGuard{

        @Override
        public String getTypeName() {
            return "\u4fdd\u5b89\u5458";
        }

        @Override
        public void validate(CredentialType credentialType, String number, String areaCode, String institutionalCode) {
            super.validate(credentialType, number, areaCode, institutionalCode);
            Date d = new Date();
            d.setHours(0);
            d.setMinutes(0);
            d.setSeconds(0);
            DateTime birthDate = IdcardUtil.getBirthDate((String)number);
            if ((institutionalCode == null || !institutionalCode.startsWith("02")) && DateValidator.dateAddYear((Date)birthDate, 18).after(d)) {
                throw new ArgumentTenantException("\u5165\u804c\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e18\u5c81");
            }
            if (institutionalCode == null || !institutionalCode.startsWith("02")) {
                if (AuthUtil.isBeijingCompany(areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)number) == 0 ? RetirementAgeUtil.isExceedRetirementAge((Date)birthDate, 50) : RetirementAgeUtil.isExceedRetirementAge((Date)birthDate, 60)) {
                        throw new ArgumentTenantException("\u6839\u636e\u6700\u65b0\u4eba\u793e\u90e8\u89c4\u5b9a\uff0c\u8be5\u4eba\u5458\u5df2\u8d85\u9f84");
                    }
                } else if (AuthUtil.isHunanCompany(areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)number) == 0) {
                        if (DateValidator.dateAddYear((Date)birthDate, 60).before(d)) {
                            throw new ArgumentTenantException("\u5165\u804c\u5973\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e60\u5c81");
                        }
                    } else if (DateValidator.dateAddYear((Date)birthDate, 60).before(d)) {
                        throw new ArgumentTenantException("\u5165\u804c\u7537\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e60\u5c81");
                    }
                } else if (AuthUtil.isNingxiaCompany(areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)number) == 0) {
                        if (DateValidator.dateAddYear((Date)birthDate, 55).before(d)) {
                            throw new ArgumentTenantException("\u5165\u804c\u5973\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e55\u5c81");
                        }
                    } else if (DateValidator.dateAddYear((Date)birthDate, 60).before(d)) {
                        throw new ArgumentTenantException("\u5165\u804c\u7537\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e60\u5c81");
                    }
                } else if (AuthUtil.isShanxiCompany(areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)number) == 0) {
                        if (DateValidator.dateAddYear((Date)birthDate, 58).before(d)) {
                            throw new ArgumentTenantException("\u5165\u804c\u5973\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e58\u5c81");
                        }
                    } else if (DateValidator.dateAddYear((Date)birthDate, 63).before(d)) {
                        throw new ArgumentTenantException("\u5165\u804c\u7537\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e63\u5c81");
                    }
                }
            }
        }
    }
    ,
    Police{

        @Override
        public String getTypeName() {
            return "\u8b66\u5458";
        }
    };


    public abstract String getTypeName();

    public void validate(CredentialType credentialType, String number, String areaCode, String institutionalCode) {
        if (credentialType == CredentialType.IdCard) {
            if (!StringUtils.hasLength((String)number)) {
                throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CredentialValidator.validate(CredentialType.IdCard, number)) {
                throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
    }
}

