/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components;

import cn.hutool.core.util.URLUtil;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;

public interface WebFileProvider {
    public InputStream download(String var1);

    @Component
    public static class WebFileProviderImpl
    implements WebFileProvider {
        private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};

        @Override
        public InputStream download(String path) {
            HttpURLConnection connection = null;
            try {
                path = URLUtil.encode((String)path);
                URL url = new URL(path);
                if (path.startsWith("https")) {
                    HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                    WebFileProviderImpl.trustAllHosts(https);
                    https.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String s, SSLSession sslSession) {
                            return true;
                        }
                    });
                    connection = https;
                } else {
                    connection = (HttpURLConnection)url.openConnection();
                }
                connection.setRequestMethod("GET");
                connection.setDoInput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Accept-Charset", "utf-8");
                connection.setConnectTimeout(20000);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                InputStream inputStream = connection.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
                return byteArrayInputStream;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BadTenantException(String.format("\u6587\u4ef6(%s)\u4e0b\u8f7d\u5931\u8d25! \u5931\u8d25\u539f\u56e0=%s", path, e.getMessage()));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }

        private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
            SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory newFactory = sc.getSocketFactory();
                connection.setSSLSocketFactory(newFactory);
            }
            catch (Exception ex) {
                ex.toString();
            }
            return oldFactory;
        }
    }
}

