package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.commons.responses.CompanyResponse;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Arrays;

/**
 * @author huangdunye
 * 2023/5/8 17:59
 */
@Getter
@Setter
public class TenantCompanyResponse implements Serializable {

    @ApiModelProperty(value = "公司名称")
    private String companyName;
    @ApiModelProperty(value = "公司类型")
    private String companyType;
    @ApiModelProperty(value = "公司电话")
    private String phone;
    @ApiModelProperty(value = "法人姓名")
    private String legalName;
    @ApiModelProperty(value = "法人身份证")
    private String legalCardNumber;
    @ApiModelProperty(value = "法人电话")
    private String legalPhone;
    @ApiModelProperty(value = "注册资本")
    private String registeredCapital;
    @ApiModelProperty(value = "服务范围")
    private String businessScope;
    @ApiModelProperty(value = "保安负责人姓名")
    private String chargeName;
    @ApiModelProperty(value = "保安负责人电话")
    private String chargePhone;
    @ApiModelProperty(value = "保安负责人证件号")
    private String chargeCardNumber;
    @ApiModelProperty(value = "监管机构")
    private String officePoliceAddress;
    @ApiModelProperty(value = "培训内容")
    private String trainingContent;
    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;
    @ApiModelProperty(value = "保安人数")
    private String recordPersonNum;


    @ApiModelProperty(value = "注册地区code")
    private String registerRegionCode;
    @ApiModelProperty(value = "注册地区")
    private String registerRegion;
    @ApiModelProperty(value = "注册详细地址")
    private String registerAddress;
    @ApiModelProperty(value = "经营地区code")
    private String businessRegionCode;
    @ApiModelProperty(value = "经营地区")
    private String businessRegion;
    @ApiModelProperty(value = "经营详细地址")
    private String businessAddress;
    @ApiModelProperty(value = "监管地区code")
    private String superviseRegionCode;
    @ApiModelProperty(value = "监管地区")
    private String superviseRegion;


    /**
     * description: 转企业返回对象信息
     * author: linchunpeng
     * date:  2023-05-10 14:22
     */
    public void setCompanyValue(CompanyResponse companyResponse) {
        //公司名称
        if (StringUtils.isNotBlank(this.getCompanyName())) {
            companyResponse.setName(this.getCompanyName());
        }
//        if (StringUtils.isNotBlank(this.getCompanyType())) {
//            companyResponse.setNature(Integer.parseInt(this.getCompanyType()));
//        }
        //联系电话
        if (StringUtils.isNotBlank(this.getPhone())) {
            companyResponse.setTelephone(this.getPhone());
        }
        //法人姓名
        if (StringUtils.isNotBlank(this.getLegalName())) {
            companyResponse.setLegalPersonName(this.getLegalName());
        }
        //法人证件号码
        if (StringUtils.isNotBlank(this.getLegalCardNumber())) {
            companyResponse.setLegalPersonCredentialNumber(this.getLegalCardNumber());
        }
        //法人手机号码
        if (StringUtils.isNotBlank(this.getLegalPhone())) {
            companyResponse.setLegalPersonTelephone(this.getLegalPhone());
        }
        //注册资本
        if (StringUtils.isNotBlank(this.getRegisteredCapital())) {
            companyResponse.setRegisteredCapital(this.getRegisteredCapital());
        }
        //服务范围
        if (StringUtils.isNotBlank(this.getBusinessScope())) {
            companyResponse.setServiceScopeList(Arrays.asList(this.getBusinessScope().split(";")));
        }
        //保安负责人姓名
        if (StringUtils.isNotBlank(this.getChargeName())) {
            companyResponse.setSecurityPersonName(this.getChargeName());
        }
        //保安负责人手机号码
        if (StringUtils.isNotBlank(this.getChargePhone())) {
            companyResponse.setSecurityPersonTelephone(this.getChargePhone());
        }
        //保安负责人证件号码
        if (StringUtils.isNotBlank(this.getChargeCardNumber())) {
            companyResponse.setSecurityPersonCredentialNumber(this.getChargeCardNumber());
        }
        //监管机构
        if (StringUtils.isNotBlank(this.getOfficePoliceAddress())) {
            companyResponse.setSuperviseDepartId(this.getOfficePoliceAddress());
        }
        //培训单位的培训内容
        if (StringUtils.isNotBlank(this.getTrainingContent())) {
            companyResponse.setTrainContent(this.getTrainingContent());
        }
        //统一社会信用代码
        if (StringUtils.isNotBlank(this.getCreditCode())) {
            companyResponse.setUnifySocialCreditCode(this.getCreditCode());
        }
        //拟自招保安员数
        if (StringUtils.isNotBlank(this.getRecordPersonNum())) {
            companyResponse.setNumberOfSecurityGuards((int) Double.parseDouble(this.getRecordPersonNum()));
        }

        //注册地区
        if (companyResponse.getPlaceOfRegister() == null) {
            companyResponse.setPlaceOfRegister(new LocationRequest());
        }
        if (StringUtils.isNotBlank(this.getRegisterRegionCode())) {
            if (companyResponse.getPlaceOfRegister().getProvince() == null) {
                companyResponse.getPlaceOfRegister().setProvince(new LocationRequest.ItemValueRequest());
            }
            if (companyResponse.getPlaceOfRegister().getCity() == null) {
                companyResponse.getPlaceOfRegister().setCity(new LocationRequest.ItemValueRequest());
            }
            if (companyResponse.getPlaceOfRegister().getDistrict() == null) {
                companyResponse.getPlaceOfRegister().setDistrict(new LocationRequest.ItemValueRequest());
            }
            companyResponse.getPlaceOfRegister().getProvince().setCode(this.getRegisterRegionCode().substring(0,2).concat("0000"));
            companyResponse.getPlaceOfRegister().getCity().setCode(this.getRegisterRegionCode().substring(0,4).concat("00"));
            companyResponse.getPlaceOfRegister().getDistrict().setCode(this.getRegisterRegionCode());
        }
        //注册地区详细地址
        if (StringUtils.isNotBlank(this.getRegisterAddress())) {
            companyResponse.getPlaceOfRegister().setAddress(this.getRegisterAddress());
        }

        //经营地区
        if (companyResponse.getPlaceOfBusiness() == null) {
            companyResponse.setPlaceOfBusiness(new LocationRequest());
        }
        if (StringUtils.isNotBlank(this.getBusinessRegionCode())) {
            if (companyResponse.getPlaceOfBusiness().getProvince() == null) {
                companyResponse.getPlaceOfBusiness().setProvince(new LocationRequest.ItemValueRequest());
            }
            if (companyResponse.getPlaceOfBusiness().getCity() == null) {
                companyResponse.getPlaceOfBusiness().setCity(new LocationRequest.ItemValueRequest());
            }
            if (companyResponse.getPlaceOfBusiness().getDistrict() == null) {
                companyResponse.getPlaceOfBusiness().setDistrict(new LocationRequest.ItemValueRequest());
            }
            companyResponse.getPlaceOfBusiness().getProvince().setCode(this.getBusinessRegionCode().substring(0,2).concat("0000"));
            companyResponse.getPlaceOfBusiness().getCity().setCode(this.getBusinessRegionCode().substring(0,4).concat("00"));
            companyResponse.getPlaceOfBusiness().getDistrict().setCode(this.getBusinessRegionCode());
        }
        //经营地区详细地址
        if (StringUtils.isNotBlank(this.getBusinessAddress())) {
            companyResponse.getPlaceOfBusiness().setAddress(this.getBusinessAddress());
        }


        //监管地区
        if (companyResponse.getPlaceOfSupervise() == null) {
            companyResponse.setPlaceOfSupervise(new LocationRequest());
        }
        if (StringUtils.isNotBlank(this.getSuperviseRegionCode())) {
            if (companyResponse.getPlaceOfSupervise().getProvince() == null) {
                companyResponse.getPlaceOfSupervise().setProvince(new LocationRequest.ItemValueRequest());
            }
            if (companyResponse.getPlaceOfSupervise().getCity() == null) {
                companyResponse.getPlaceOfSupervise().setCity(new LocationRequest.ItemValueRequest());
            }
            if (companyResponse.getPlaceOfSupervise().getDistrict() == null) {
                companyResponse.getPlaceOfSupervise().setDistrict(new LocationRequest.ItemValueRequest());
            }
            companyResponse.getPlaceOfSupervise().getProvince().setCode(this.getSuperviseRegionCode().substring(0,2).concat("0000"));
            companyResponse.getPlaceOfSupervise().getCity().setCode(this.getSuperviseRegionCode().substring(0,4).concat("00"));
            companyResponse.getPlaceOfSupervise().getDistrict().setCode(this.getSuperviseRegionCode());
        }
    }


    /**
     * description: 转注册对象信息
     * author: linchunpeng
     * date:  2023-05-10 14:22
     */
    public void setCompanyRegistrationRequestValue(CompanyRegistrationRequest registrationRequest) {
        //公司名称
        if (StringUtils.isNotBlank(this.getCompanyName())) {
            registrationRequest.setName(this.getCompanyName());
        }
//        if (StringUtils.isNotBlank(this.getCompanyType())) {
//            registrationRequest.setNature(CompanyNature.values()[Integer.parseInt(this.getCompanyType())]);
//        }
        //联系电话
        if (StringUtils.isNotBlank(this.getPhone())) {
            registrationRequest.setTelephone(this.getPhone());
        }
        //法人姓名
        if (StringUtils.isNotBlank(this.getLegalName())) {
            registrationRequest.setLegalPersonName(this.getLegalName());
        }
        //法人证件号码
        if (StringUtils.isNotBlank(this.getLegalCardNumber())) {
            registrationRequest.setLegalPersonCredentialNumber(this.getLegalCardNumber());
        }
        //法人手机号码
        if (StringUtils.isNotBlank(this.getLegalPhone())) {
            registrationRequest.setLegalPersonTelephone(this.getLegalPhone());
        }
        //注册资本
        if (StringUtils.isNotBlank(this.getRegisteredCapital())) {
            registrationRequest.setRegisteredCapital(this.getRegisteredCapital());
        }
        //服务范围
        if (StringUtils.isNotBlank(this.getBusinessScope())) {
            registrationRequest.setServiceScopeList(Arrays.asList(this.getBusinessScope().split(";")));
        }
        //保安负责人姓名
        if (StringUtils.isNotBlank(this.getChargeName())) {
            registrationRequest.setSecurityPersonName(this.getChargeName());
        }
        //保安负责人手机号码
        if (StringUtils.isNotBlank(this.getChargePhone())) {
            registrationRequest.setSecurityPersonTelephone(this.getChargePhone());
        }
        //保安负责人证件号码
        if (StringUtils.isNotBlank(this.getChargeCardNumber())) {
            registrationRequest.setSecurityPersonCredentialNumber(this.getChargeCardNumber());
        }
        //监管机构
        if (StringUtils.isNotBlank(this.getOfficePoliceAddress())) {
            registrationRequest.setSuperviseDepartId(this.getOfficePoliceAddress());
        }
        //培训单位的培训内容
        if (StringUtils.isNotBlank(this.getTrainingContent())) {
            registrationRequest.setTrainContent(this.getTrainingContent());
        }
        //统一社会信用代码
        if (StringUtils.isNotBlank(this.getCreditCode())) {
            registrationRequest.setUnifySocialCreditCode(this.getCreditCode());
        }
        //拟自招保安员数
        if (StringUtils.isNotBlank(this.getRecordPersonNum())) {
            registrationRequest.setNumberOfSecurityGuards(Integer.parseInt(this.getRecordPersonNum()));
        }

        //注册地区
        if (registrationRequest.getPlaceOfRegister() == null) {
            registrationRequest.setPlaceOfRegister(new LocationRequest());
        }
        if (StringUtils.isNotBlank(this.getRegisterRegionCode())) {
            if (registrationRequest.getPlaceOfRegister().getProvince() == null) {
                registrationRequest.getPlaceOfRegister().setProvince(new LocationRequest.ItemValueRequest());
            }
            if (registrationRequest.getPlaceOfRegister().getCity() == null) {
                registrationRequest.getPlaceOfRegister().setCity(new LocationRequest.ItemValueRequest());
            }
            if (registrationRequest.getPlaceOfRegister().getDistrict() == null) {
                registrationRequest.getPlaceOfRegister().setDistrict(new LocationRequest.ItemValueRequest());
            }
            registrationRequest.getPlaceOfRegister().getProvince().setCode(this.getRegisterRegionCode().substring(0,2).concat("0000"));
            registrationRequest.getPlaceOfRegister().getCity().setCode(this.getRegisterRegionCode().substring(0,4).concat("00"));
            registrationRequest.getPlaceOfRegister().getDistrict().setCode(this.getRegisterRegionCode());
        }
        //注册地区详细地址
        if (StringUtils.isNotBlank(this.getRegisterAddress())) {
            registrationRequest.getPlaceOfRegister().setAddress(this.getRegisterAddress());
        }

        //经营地区
        if (registrationRequest.getPlaceOfBusiness() == null) {
            registrationRequest.setPlaceOfBusiness(new LocationRequest());
        }
        if (StringUtils.isNotBlank(this.getBusinessRegionCode())) {
            if (registrationRequest.getPlaceOfBusiness().getProvince() == null) {
                registrationRequest.getPlaceOfBusiness().setProvince(new LocationRequest.ItemValueRequest());
            }
            if (registrationRequest.getPlaceOfBusiness().getCity() == null) {
                registrationRequest.getPlaceOfBusiness().setCity(new LocationRequest.ItemValueRequest());
            }
            if (registrationRequest.getPlaceOfBusiness().getDistrict() == null) {
                registrationRequest.getPlaceOfBusiness().setDistrict(new LocationRequest.ItemValueRequest());
            }
            registrationRequest.getPlaceOfBusiness().getProvince().setCode(this.getBusinessRegionCode().substring(0,2).concat("0000"));
            registrationRequest.getPlaceOfBusiness().getCity().setCode(this.getBusinessRegionCode().substring(0,4).concat("00"));
            registrationRequest.getPlaceOfBusiness().getDistrict().setCode(this.getBusinessRegionCode());
        }
        //经营地区详细地址
        if (StringUtils.isNotBlank(this.getBusinessAddress())) {
            registrationRequest.getPlaceOfBusiness().setAddress(this.getBusinessAddress());
        }

        //监管地区
        if (registrationRequest.getPlaceOfSupervise() == null) {
            registrationRequest.setPlaceOfSupervise(new LocationRequest());
        }
        if (StringUtils.isNotBlank(this.getSuperviseRegionCode())) {
            if (registrationRequest.getPlaceOfSupervise().getProvince() == null) {
                registrationRequest.getPlaceOfSupervise().setProvince(new LocationRequest.ItemValueRequest());
            }
            if (registrationRequest.getPlaceOfSupervise().getCity() == null) {
                registrationRequest.getPlaceOfSupervise().setCity(new LocationRequest.ItemValueRequest());
            }
            if (registrationRequest.getPlaceOfSupervise().getDistrict() == null) {
                registrationRequest.getPlaceOfSupervise().setDistrict(new LocationRequest.ItemValueRequest());
            }
            registrationRequest.getPlaceOfSupervise().getProvince().setCode(this.getSuperviseRegionCode().substring(0,2).concat("0000"));
            registrationRequest.getPlaceOfSupervise().getCity().setCode(this.getSuperviseRegionCode().substring(0,4).concat("00"));
            registrationRequest.getPlaceOfSupervise().getDistrict().setCode(this.getSuperviseRegionCode());
        }
    }

}
